/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import mekanism.api.math.MathUtils;
import mekanism.common.lib.distribution.IntegerSplitInfo;
import mekanism.common.lib.distribution.LongSplitInfo;
import mekanism.common.lib.distribution.SplitInfo;
import mekanism.common.lib.distribution.Target;
import org.jetbrains.annotations.Nullable;

public class EmitUtils {
    private EmitUtils() {
    }

    private static <HANDLER, RESOURCE, TARGET extends Target<HANDLER, RESOURCE>> long sendToAcceptors(TARGET availableTargets, SplitInfo splitInfo, RESOURCE resource) {
        if (availableTargets.getHandlerCount() == 0) {
            return splitInfo.getTotalSent();
        }
        availableTargets.sendPossible(resource, splitInfo);
        while (splitInfo.amountPerChanged) {
            splitInfo.amountPerChanged = false;
            availableTargets.shiftNeeded(resource, splitInfo);
        }
        availableTargets.sendRemainingSplit(resource, splitInfo);
        return splitInfo.getTotalSent();
    }

    public static <HANDLER, RESOURCE, TARGET extends Target<HANDLER, RESOURCE>> int sendToAcceptors(@Nullable TARGET availableTargets, int amountToSplit, RESOURCE toSend) {
        if (availableTargets == null || availableTargets.getHandlerCount() == 0) {
            return 0;
        }
        return MathUtils.clampToInt(EmitUtils.sendToAcceptors(availableTargets, new IntegerSplitInfo(amountToSplit, availableTargets.getHandlerCount()), toSend));
    }

    public static <HANDLER, RESOURCE, TARGET extends Target<HANDLER, RESOURCE>> long sendToAcceptors(@Nullable TARGET availableTargets, long amountToSplit, RESOURCE resource) {
        if (availableTargets == null || availableTargets.getHandlerCount() == 0) {
            return 0L;
        }
        return EmitUtils.sendToAcceptors(availableTargets, new LongSplitInfo(amountToSplit, availableTargets.getHandlerCount()), resource);
    }
}

