/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import java.util.Optional;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import org.jetbrains.annotations.Nullable;

public class RegistryUtils {
    private RegistryUtils() {
    }

    public static Holder<BlockEntityType<?>> getBEHolder(BlockEntityType<?> type) {
        Holder.Reference holder = type.builtInRegistryHolder();
        if (holder == null) {
            return BuiltInRegistries.BLOCK_ENTITY_TYPE.wrapAsHolder(type);
        }
        return holder;
    }

    public static <R> Optional<Holder.Reference<R>> getHolderById(CompoundTag nbt, Registry<R> registry) {
        ResourceLocation name;
        if (nbt != null && nbt.contains("id", 8) && (name = ResourceLocation.tryParse((String)nbt.getString("id"))) != null) {
            return registry.getHolder(name);
        }
        return Optional.empty();
    }

    public static String getPath(Block element) {
        return BuiltInRegistries.BLOCK.getKey((Object)element).getPath();
    }

    public static <TYPE> ResourceLocation getName(Holder<TYPE> element, DefaultedRegistry<TYPE> registry) {
        ResourceKey key = element.getKey();
        if (key == null) {
            return registry.getKey(element.value());
        }
        return key.location();
    }

    @Nullable
    public static ResourceLocation getName(Holder<?> element) {
        ResourceKey key = element.getKey();
        return key == null ? null : key.location();
    }

    @Nullable
    public static ResourceLocation getNameGeneric(Object element) {
        if (element instanceof Holder) {
            Holder holder = (Holder)element;
            return RegistryUtils.getName(holder);
        }
        for (Registry registry : BuiltInRegistries.REGISTRY) {
            ResourceLocation name = registry.getKeyOrNull(element);
            if (name == null) continue;
            return name;
        }
        return null;
    }
}

