/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.world;

import com.mojang.serialization.MapCodec;
import mekanism.common.config.MekanismConfig;
import mekanism.common.registries.MekanismIntProviderTypes;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.IntProviderType;
import org.jetbrains.annotations.NotNull;

public class ConfigurableUniformInt
extends IntProvider {
    public static final ConfigurableUniformInt SALT = new ConfigurableUniformInt();
    public static final MapCodec<ConfigurableUniformInt> CODEC = MapCodec.unit((Object)((Object)SALT));

    private ConfigurableUniformInt() {
    }

    public int sample(@NotNull RandomSource random) {
        return Mth.randomBetweenInclusive((RandomSource)random, (int)this.getMinValue(), (int)this.getMaxValue());
    }

    public int getMinValue() {
        return MekanismConfig.world.salt.minRadius.get();
    }

    public int getMaxValue() {
        return MekanismConfig.world.salt.maxRadius.get();
    }

    @NotNull
    public IntProviderType<?> getType() {
        return (IntProviderType)MekanismIntProviderTypes.CONFIGURABLE_UNIFORM.get();
    }

    public String toString() {
        return "[" + this.getMinValue() + "-" + this.getMaxValue() + "]";
    }
}

