/*
 * Decompiled with CFR 0.152.
 */
package com.example.structurecraft;

import com.example.structurecraft.ChunkGenerationListener;
import com.example.structurecraft.StructureCraftCommand;
import com.example.structurecraft.StructureManager;
import java.io.File;
import java.io.IOException;
import java.util.Random;
import java.util.logging.Level;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class StructureCraft
extends JavaPlugin {
    private File schematicsFolder;
    private File structuresConfigFile;
    private FileConfiguration structuresConfig;
    private final Random random = new Random();
    private StructureManager structureManager;

    public void onEnable() {
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdir();
        }
        this.schematicsFolder = new File(this.getDataFolder(), "schematics");
        if (!this.schematicsFolder.exists()) {
            this.schematicsFolder.mkdir();
        }
        this.loadStructuresConfig();
        this.saveDefaultConfig();
        this.structureManager = new StructureManager(this);
        this.getServer().getPluginManager().registerEvents((Listener)new ChunkGenerationListener(this), (Plugin)this);
        this.getCommand("structurecraft").setExecutor((CommandExecutor)new StructureCraftCommand(this));
        this.getLogger().info("StructureCraft has been enabled!");
    }

    public void onDisable() {
        this.getLogger().info("StructureCraft has been disabled!");
    }

    public void loadStructuresConfig() {
        this.structuresConfigFile = new File(this.getDataFolder(), "structures.yml");
        if (!this.structuresConfigFile.exists()) {
            this.saveResource("structures.yml", false);
        }
        this.structuresConfig = YamlConfiguration.loadConfiguration((File)this.structuresConfigFile);
    }

    public void saveStructuresConfig() {
        try {
            this.structuresConfig.save(this.structuresConfigFile);
        }
        catch (IOException e) {
            this.getLogger().log(Level.SEVERE, "Could not save structures config!", e);
        }
    }

    public void reloadAllConfigs() {
        this.reloadConfig();
        this.loadStructuresConfig();
        this.structureManager.loadStructures();
    }

    public File getSchematicsFolder() {
        return this.schematicsFolder;
    }

    public FileConfiguration getStructuresConfig() {
        return this.structuresConfig;
    }

    public StructureManager getStructureManager() {
        return this.structureManager;
    }
}

