/*
 * Decompiled with CFR 0.152.
 */
package com.example.structurecraft;

import com.example.structurecraft.StructurePlacement;
import com.example.structurecraft.StructureRarity;
import java.util.List;

public class CustomStructure {
    private final String name;
    private final String schematicName;
    private final StructurePlacement placement;
    private final StructureRarity rarity;
    private final List<String> biomes;
    private final int minY;
    private final int maxY;
    private final int sizeX;
    private final int sizeZ;

    public CustomStructure(String name, String schematicName, StructurePlacement placement, StructureRarity rarity, List<String> biomes, int minY, int maxY, int sizeX, int sizeZ) {
        this.name = name;
        this.schematicName = schematicName;
        this.placement = placement;
        this.rarity = rarity;
        this.biomes = biomes;
        this.minY = minY;
        this.maxY = maxY;
        this.sizeX = sizeX > 0 ? sizeX : 1;
        this.sizeZ = sizeZ > 0 ? sizeZ : 1;
    }

    public CustomStructure(String name, String schematicName, StructurePlacement placement, StructureRarity rarity, List<String> biomes, int minY, int maxY) {
        this(name, schematicName, placement, rarity, biomes, minY, maxY, 1, 1);
    }

    public String getName() {
        return this.name;
    }

    public String getSchematicName() {
        return this.schematicName;
    }

    public StructurePlacement getPlacement() {
        return this.placement;
    }

    public StructureRarity getRarity() {
        return this.rarity;
    }

    public List<String> getBiomes() {
        return this.biomes;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public int getSizeX() {
        return this.sizeX;
    }

    public int getSizeZ() {
        return this.sizeZ;
    }

    public boolean isMultiChunk() {
        return this.sizeX > 1 || this.sizeZ > 1;
    }
}

