/*
 * Decompiled with CFR 0.152.
 */
package com.example.structurecraft;

import com.example.structurecraft.CustomStructure;
import com.example.structurecraft.StructureCraft;
import com.example.structurecraft.StructureRarity;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class StructureCraftCommand
implements CommandExecutor,
TabCompleter {
    private final StructureCraft plugin;

    public StructureCraftCommand(StructureCraft plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "StructureCraft v" + this.plugin.getDescription().getVersion());
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/structurecraft reload - Reload configurations");
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/structurecraft list - List all loaded structures");
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/structurecraft generate [world] - Generate structures in the specified world or current world");
            return true;
        }
        if (args[0].equalsIgnoreCase("reload")) {
            if (!sender.hasPermission("structurecraft.reload")) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
                return true;
            }
            this.plugin.reloadAllConfigs();
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "StructureCraft configurations reloaded!");
            return true;
        }
        if (args[0].equalsIgnoreCase("list")) {
            if (!sender.hasPermission("structurecraft.list")) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
                return true;
            }
            Map<String, CustomStructure> structures = this.plugin.getStructureManager().getStructures();
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Loaded structures (" + structures.size() + "):");
            for (CustomStructure structure : structures.values()) {
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "- " + structure.getName() + " (" + (switch (structure.getRarity()) {
                    case StructureRarity.COMMON -> ChatColor.GREEN.toString();
                    case StructureRarity.RARE -> ChatColor.BLUE.toString();
                    case StructureRarity.EPIC -> ChatColor.LIGHT_PURPLE.toString();
                    default -> ChatColor.WHITE.toString();
                }) + String.valueOf((Object)structure.getRarity()) + String.valueOf(ChatColor.YELLOW) + ", " + String.valueOf((Object)structure.getPlacement()) + ")");
            }
            return true;
        }
        if (args[0].equalsIgnoreCase("generate")) {
            World world;
            if (!sender.hasPermission("structurecraft.generate")) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
                return true;
            }
            if (args.length > 1) {
                world = this.plugin.getServer().getWorld(args[1]);
                if (world == null) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "World '" + args[1] + "' not found.");
                    return true;
                }
            } else if (sender instanceof Player) {
                world = ((Player)sender).getWorld();
            } else {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Please specify a world name when running from console.");
                return true;
            }
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Starting structure generation in world '" + world.getName() + "'");
            this.plugin.getStructureManager().generateStructuresInWorld(world);
            return true;
        }
        sender.sendMessage(String.valueOf(ChatColor.RED) + "Unknown command. Type /structurecraft for help.");
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            if (sender.hasPermission("structurecraft.reload")) {
                completions.add("reload");
            }
            if (sender.hasPermission("structurecraft.list")) {
                completions.add("list");
            }
            if (sender.hasPermission("structurecraft.generate")) {
                completions.add("generate");
            }
        } else if (args.length == 2 && args[0].equalsIgnoreCase("generate")) {
            for (World world : this.plugin.getServer().getWorlds()) {
                completions.add(world.getName());
            }
        }
        return completions;
    }
}

