/*
 * Decompiled with CFR 0.152.
 */
package com.example.structurecraft;

import com.example.structurecraft.CustomStructure;
import com.example.structurecraft.StructureCraft;
import com.example.structurecraft.StructurePlacement;
import com.example.structurecraft.StructureRarity;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormat;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormats;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardReader;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.function.operation.Operations;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.session.ClipboardHolder;
import com.sk89q.worldedit.world.World;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Container;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class StructureManager {
    private final StructureCraft plugin;
    private final Map<String, CustomStructure> structures = new HashMap<String, CustomStructure>();
    private final Random random = new Random();

    public StructureManager(StructureCraft plugin) {
        this.plugin = plugin;
        this.loadStructures();
    }

    public void loadStructures() {
        this.structures.clear();
        ConfigurationSection structureSection = this.plugin.getStructuresConfig().getConfigurationSection("structures");
        if (structureSection == null) {
            this.plugin.getLogger().warning("No structures defined in structures.yml");
            return;
        }
        for (String key : structureSection.getKeys(false)) {
            try {
                ConfigurationSection section = structureSection.getConfigurationSection(key);
                if (section == null) continue;
                String schematicName = section.getString("schematic");
                String placementType = section.getString("placement", "ground").toLowerCase();
                String rarityStr = section.getString("rarity", "common").toLowerCase();
                List biomes = section.getStringList("biomes");
                int minY = section.getInt("min_y", 60);
                int maxY = section.getInt("max_y", 120);
                int sizeX = section.getInt("size_x", 1);
                int sizeZ = section.getInt("size_z", 1);
                File schematicFile = new File(this.plugin.getSchematicsFolder(), schematicName);
                if (!schematicFile.exists()) {
                    this.plugin.getLogger().warning("Schematic file not found: " + schematicName);
                    continue;
                }
                CustomStructure structure = new CustomStructure(key, schematicName, switch (placementType) {
                    case "air" -> StructurePlacement.AIR;
                    case "underground" -> StructurePlacement.UNDERGROUND;
                    default -> StructurePlacement.GROUND;
                }, switch (rarityStr) {
                    case "rare" -> StructureRarity.RARE;
                    case "epic" -> StructureRarity.EPIC;
                    default -> StructureRarity.COMMON;
                }, biomes, minY, maxY, sizeX, sizeZ);
                this.structures.put(key, structure);
                if (structure.isMultiChunk()) {
                    this.plugin.getLogger().info("Loaded multi-chunk structure: " + key + " (Size: " + sizeX + "x" + sizeZ + " chunks)");
                    continue;
                }
                this.plugin.getLogger().info("Loaded structure: " + key);
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.WARNING, "Failed to load structure: " + key, e);
            }
        }
        this.plugin.getLogger().info("Loaded " + this.structures.size() + " structures");
    }

    private void applyStructureModifications(CustomStructure structure, Location location) {
        if (!this.plugin.getConfig().getBoolean("features.apply-modifications", true)) {
            return;
        }
        org.bukkit.World world = location.getWorld();
        int searchRadius = 16;
        if (structure.isMultiChunk()) {
            searchRadius = Math.max(structure.getSizeX(), structure.getSizeZ()) * 16;
        }
        this.plugin.getLogger().info("Applying modifications to structure: " + structure.getName() + " at " + location.getBlockX() + "," + location.getBlockY() + "," + location.getBlockZ());
        final CustomStructure finalStructure = structure;
        final Location finalLocation = location;
        final int finalSearchRadius = searchRadius;
        new BukkitRunnable(this){
            final /* synthetic */ StructureManager this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                this.this$0.addLootToChests(finalStructure, finalLocation, finalSearchRadius);
                this.this$0.spawnMobs(finalStructure, finalLocation, finalSearchRadius);
            }
        }.runTaskLater((Plugin)this.plugin, 10L);
    }

    private void addLootToChests(CustomStructure structure, Location location, int searchRadius) {
        org.bukkit.World world = location.getWorld();
        int count = 0;
        for (int x = -searchRadius; x <= searchRadius; ++x) {
            for (int y = -searchRadius; y <= searchRadius; ++y) {
                for (int z = -searchRadius; z <= searchRadius; ++z) {
                    Block block = world.getBlockAt(location.getBlockX() + x, location.getBlockY() + y, location.getBlockZ() + z);
                    if (block.getType() != Material.CHEST && block.getType() != Material.TRAPPED_CHEST && block.getType() != Material.BARREL) continue;
                    Container container = (Container)block.getState();
                    Inventory inventory = container.getInventory();
                    inventory.clear();
                    this.fillContainerWithLoot(inventory, structure.getRarity());
                    container.update();
                    ++count;
                }
            }
        }
        if (count > 0) {
            this.plugin.getLogger().info("Added loot to " + count + " containers in structure: " + structure.getName());
        }
    }

    private void fillContainerWithLoot(Inventory inventory, StructureRarity rarity) {
        int minItems;
        Random random = new Random();
        int itemCount = minItems + random.nextInt((switch (rarity) {
            case StructureRarity.EPIC -> {
                minItems = 5;
                yield 12;
            }
            case StructureRarity.RARE -> {
                minItems = 3;
                yield 8;
            }
            default -> {
                minItems = 1;
                yield 5;
            }
        }) - minItems + 1);
        for (int i = 0; i < itemCount; ++i) {
            int slot = random.nextInt(inventory.getSize());
            ItemStack item = this.generateRandomItem(rarity);
            if (inventory.getItem(slot) != null) {
                for (int attempt = 0; attempt < inventory.getSize(); ++attempt) {
                    int newSlot = (slot + attempt) % inventory.getSize();
                    if (inventory.getItem(newSlot) != null) continue;
                    slot = newSlot;
                    break;
                }
            }
            inventory.setItem(slot, item);
        }
    }

    private ItemStack generateRandomItem(StructureRarity rarity) {
        Random random = new Random();
        List<Material> commonItems = Arrays.asList(Material.COAL, Material.IRON_INGOT, Material.BREAD, Material.APPLE, Material.ARROW, Material.LEATHER, Material.WHEAT, Material.STICK, Material.STONE_SWORD, Material.LEATHER_BOOTS, Material.LEATHER_CHESTPLATE);
        List<Material> rareItems = Arrays.asList(Material.GOLD_INGOT, Material.IRON_SWORD, Material.IRON_PICKAXE, Material.IRON_AXE, Material.IRON_BOOTS, Material.IRON_CHESTPLATE, Material.GOLDEN_APPLE, Material.EMERALD, Material.EXPERIENCE_BOTTLE);
        List<Material> epicItems = Arrays.asList(Material.DIAMOND, Material.DIAMOND_SWORD, Material.ENCHANTED_GOLDEN_APPLE, Material.DIAMOND_BOOTS, Material.DIAMOND_CHESTPLATE, Material.NETHERITE_SCRAP, Material.ANCIENT_DEBRIS, Material.ENCHANTED_BOOK, Material.TOTEM_OF_UNDYING);
        int chance = random.nextInt(100);
        Material material = switch (rarity) {
            case StructureRarity.EPIC -> {
                if (chance < 30) {
                    yield epicItems.get(random.nextInt(epicItems.size()));
                }
                if (chance < 70) {
                    yield rareItems.get(random.nextInt(rareItems.size()));
                }
                yield commonItems.get(random.nextInt(commonItems.size()));
            }
            case StructureRarity.RARE -> {
                if (chance < 10) {
                    yield epicItems.get(random.nextInt(epicItems.size()));
                }
                if (chance < 60) {
                    yield rareItems.get(random.nextInt(rareItems.size()));
                }
                yield commonItems.get(random.nextInt(commonItems.size()));
            }
            default -> chance < 5 ? rareItems.get(random.nextInt(rareItems.size())) : commonItems.get(random.nextInt(commonItems.size()));
        };
        int maxStackSize = material.getMaxStackSize();
        int amount = 1;
        if (maxStackSize > 1) {
            switch (rarity) {
                case EPIC: {
                    amount = 1 + random.nextInt(Math.min(maxStackSize, 16));
                    break;
                }
                case RARE: {
                    amount = 1 + random.nextInt(Math.min(maxStackSize, 8));
                    break;
                }
                default: {
                    amount = 1 + random.nextInt(Math.min(maxStackSize, 4));
                }
            }
        }
        ItemStack item = new ItemStack(material, amount);
        if ((material.toString().contains("SWORD") || material.toString().contains("AXE") || material.toString().contains("BOW") || material.toString().contains("HELMET") || material.toString().contains("CHESTPLATE") || material.toString().contains("LEGGINGS") || material.toString().contains("BOOTS")) && random.nextInt(100) < this.getRarityEnchantChance(rarity)) {
            this.addRandomEnchantments(item, rarity);
        }
        return item;
    }

    private int getRarityEnchantChance(StructureRarity rarity) {
        switch (rarity) {
            case EPIC: {
                return 80;
            }
            case RARE: {
                return 50;
            }
        }
        return 20;
    }

    private void addRandomEnchantments(ItemStack item, StructureRarity rarity) {
        Random random = new Random();
        ArrayList<Enchantment> applicableEnchants = new ArrayList<Enchantment>();
        for (Enchantment enchant : Enchantment.values()) {
            if (!enchant.canEnchantItem(item)) continue;
            applicableEnchants.add(enchant);
        }
        if (applicableEnchants.isEmpty()) {
            return;
        }
        int numEnchants = 1 + random.nextInt(switch (rarity) {
            case StructureRarity.EPIC -> 3;
            case StructureRarity.RARE -> 2;
            default -> 1;
        });
        numEnchants = Math.min(numEnchants, applicableEnchants.size());
        Collections.shuffle(applicableEnchants);
        for (int i = 0; i < numEnchants; ++i) {
            int level;
            Enchantment enchant;
            enchant = (Enchantment)applicableEnchants.get(i);
            switch (rarity) {
                case EPIC: {
                    level = random.nextInt(enchant.getMaxLevel()) + 1;
                    if (random.nextInt(100) >= 20) break;
                    ++level;
                    break;
                }
                case RARE: {
                    level = random.nextInt(enchant.getMaxLevel()) + 1;
                    break;
                }
                default: {
                    level = 1;
                    if (enchant.getMaxLevel() <= 1 || random.nextInt(100) >= 30) break;
                    level = 2;
                }
            }
            item.addUnsafeEnchantment(enchant, level);
        }
    }

    private void spawnMobs(CustomStructure structure, Location location, int searchRadius) {
        org.bukkit.World world = location.getWorld();
        Random random = new Random();
        ArrayList<Location> potentialSpawnPoints = new ArrayList<Location>();
        for (int x = -searchRadius; x <= searchRadius; x += 4) {
            for (int z = -searchRadius; z <= searchRadius; z += 4) {
                int startY = searchRadius;
                if (structure.getPlacement() == StructurePlacement.UNDERGROUND) {
                    startY = 5;
                }
                for (int y = -startY; y <= startY; y += 2) {
                    Location checkLoc = new Location(world, (double)(location.getBlockX() + x), (double)(location.getBlockY() + y), (double)(location.getBlockZ() + z));
                    Block block = checkLoc.getBlock();
                    Block blockAbove = world.getBlockAt(checkLoc.getBlockX(), checkLoc.getBlockY() + 1, checkLoc.getBlockZ());
                    Block blockBelow = world.getBlockAt(checkLoc.getBlockX(), checkLoc.getBlockY() - 1, checkLoc.getBlockZ());
                    if (block.getType() != Material.AIR || blockAbove.getType() != Material.AIR || !blockBelow.getType().isSolid()) continue;
                    potentialSpawnPoints.add(checkLoc);
                }
            }
        }
        if (potentialSpawnPoints.isEmpty()) {
            this.plugin.getLogger().info("No valid spawn points found for mobs in structure: " + structure.getName());
            return;
        }
        int mobCount = random.nextInt((switch (structure.getRarity()) {
            case StructureRarity.EPIC -> 8;
            case StructureRarity.RARE -> 5;
            default -> 3;
        }) + 1);
        int spawnedCount = 0;
        Collections.shuffle(potentialSpawnPoints);
        List<EntityType> mobTypes = this.getMobTypesForStructure(structure);
        for (int i = 0; i < mobCount && i < potentialSpawnPoints.size(); ++i) {
            EntityType mobType;
            Location spawnLoc = (Location)potentialSpawnPoints.get(i);
            Entity entity = world.spawnEntity(spawnLoc, mobType = mobTypes.get(random.nextInt(mobTypes.size())));
            if (entity instanceof LivingEntity && entity instanceof Monster) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (random.nextInt(100) < (switch (structure.getRarity()) {
                    case StructureRarity.EPIC -> 70;
                    case StructureRarity.RARE -> 40;
                    default -> 20;
                })) {
                    this.equipMob(livingEntity, structure.getRarity());
                }
            }
            ++spawnedCount;
        }
        if (spawnedCount > 0) {
            this.plugin.getLogger().info("Spawned " + spawnedCount + " mobs in structure: " + structure.getName());
        }
    }

    private List<EntityType> getMobTypesForStructure(CustomStructure structure) {
        ArrayList<EntityType> mobTypes = new ArrayList<EntityType>();
        switch (structure.getPlacement()) {
            case UNDERGROUND: {
                mobTypes.addAll(Arrays.asList(EntityType.ZOMBIE, EntityType.SKELETON, EntityType.SPIDER, EntityType.CREEPER, EntityType.SILVERFISH));
                break;
            }
            case AIR: {
                mobTypes.addAll(Arrays.asList(EntityType.PHANTOM, EntityType.BLAZE, EntityType.GHAST));
                break;
            }
            default: {
                if (structure.getRarity() == StructureRarity.EPIC) {
                    mobTypes.addAll(Arrays.asList(EntityType.ZOMBIE, EntityType.SKELETON, EntityType.SPIDER, EntityType.CREEPER, EntityType.WITCH, EntityType.VINDICATOR, EntityType.PILLAGER, EntityType.RAVAGER));
                    break;
                }
                if (structure.getRarity() == StructureRarity.RARE) {
                    mobTypes.addAll(Arrays.asList(EntityType.ZOMBIE, EntityType.SKELETON, EntityType.SPIDER, EntityType.CREEPER, EntityType.WITCH));
                    break;
                }
                mobTypes.addAll(Arrays.asList(EntityType.ZOMBIE, EntityType.SKELETON, EntityType.SPIDER));
            }
        }
        if (structure.getRarity() == StructureRarity.EPIC) {
            mobTypes.add(EntityType.EVOKER);
            mobTypes.add(EntityType.ILLUSIONER);
            mobTypes.add(EntityType.WITHER_SKELETON);
        } else if (structure.getRarity() == StructureRarity.RARE) {
            mobTypes.add(EntityType.VINDICATOR);
            mobTypes.add(EntityType.PILLAGER);
        }
        return mobTypes;
    }

    private void equipMob(LivingEntity entity, StructureRarity rarity) {
        EntityEquipment equipment;
        String materialName;
        Material armorMaterial;
        Random random = new Random();
        ItemStack weapon = new ItemStack(switch (rarity) {
            case StructureRarity.EPIC -> {
                if (random.nextInt(100) < 20) {
                    armorMaterial = Material.NETHERITE_CHESTPLATE;
                    yield Material.NETHERITE_SWORD;
                }
                armorMaterial = Material.DIAMOND_CHESTPLATE;
                yield Material.DIAMOND_SWORD;
            }
            case StructureRarity.RARE -> {
                if (random.nextInt(100) < 70) {
                    armorMaterial = Material.IRON_CHESTPLATE;
                    yield Material.IRON_SWORD;
                }
                armorMaterial = Material.DIAMOND_CHESTPLATE;
                yield Material.DIAMOND_SWORD;
            }
            default -> {
                if (random.nextInt(100) < 70) {
                    armorMaterial = Material.LEATHER_CHESTPLATE;
                    yield Material.STONE_SWORD;
                }
                armorMaterial = Material.IRON_CHESTPLATE;
                yield Material.IRON_SWORD;
            }
        });
        ItemStack helmet = null;
        ItemStack chestplate = null;
        ItemStack leggings = null;
        ItemStack boots = null;
        if (random.nextInt(100) < 60) {
            materialName = armorMaterial.toString().replace("_CHESTPLATE", "");
            helmet = new ItemStack(Material.valueOf((String)(materialName + "_HELMET")));
        }
        if (random.nextInt(100) < 80) {
            chestplate = new ItemStack(armorMaterial);
        }
        if (random.nextInt(100) < 60) {
            materialName = armorMaterial.toString().replace("_CHESTPLATE", "");
            leggings = new ItemStack(Material.valueOf((String)(materialName + "_LEGGINGS")));
        }
        if (random.nextInt(100) < 60) {
            materialName = armorMaterial.toString().replace("_CHESTPLATE", "");
            boots = new ItemStack(Material.valueOf((String)(materialName + "_BOOTS")));
        }
        if (random.nextInt(100) < this.getRarityEnchantChance(rarity)) {
            if (weapon != null) {
                this.addRandomEnchantments(weapon, rarity);
            }
            if (helmet != null) {
                this.addRandomEnchantments(helmet, rarity);
            }
            if (chestplate != null) {
                this.addRandomEnchantments(chestplate, rarity);
            }
            if (leggings != null) {
                this.addRandomEnchantments(leggings, rarity);
            }
            if (boots != null) {
                this.addRandomEnchantments(boots, rarity);
            }
        }
        if ((equipment = entity.getEquipment()) != null) {
            equipment.setItemInMainHand(weapon);
            equipment.setHelmet(helmet);
            equipment.setChestplate(chestplate);
            equipment.setLeggings(leggings);
            equipment.setBoots(boots);
            float dropChance = switch (rarity) {
                case StructureRarity.EPIC -> 0.05f;
                case StructureRarity.RARE -> 0.08f;
                default -> 0.1f;
            };
            equipment.setItemInMainHandDropChance(dropChance);
            equipment.setHelmetDropChance(dropChance);
            equipment.setChestplateDropChance(dropChance);
            equipment.setLeggingsDropChance(dropChance);
            equipment.setBootsDropChance(dropChance);
        }
    }

    public void generateStructuresInWorld(final org.bukkit.World world) {
        final int worldRadius = this.plugin.getConfig().getInt("generation.world-radius", 1000);
        final int minStructures = this.plugin.getConfig().getInt("generation.min-structures", 10);
        final int maxAttempts = this.plugin.getConfig().getInt("generation.attempts-per-world", 500);
        final int chunksPerTick = this.plugin.getConfig().getInt("generation.chunks-per-tick", 10);
        this.plugin.getLogger().info("Starting structure generation in world: " + world.getName());
        this.plugin.getLogger().info("World radius: " + worldRadius + " blocks, Min structures: " + minStructures + ", Max attempts: " + maxAttempts);
        new BukkitRunnable(this){
            private int currentAttempt = 0;
            private int structuresPlaced = 0;
            final /* synthetic */ StructureManager this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                int processedThisTick = 0;
                while ((this.structuresPlaced < minStructures || this.currentAttempt < maxAttempts) && processedThisTick < chunksPerTick && this.currentAttempt < maxAttempts) {
                    boolean placed;
                    int chunkZ;
                    int chunkX = this.this$0.random.nextInt(worldRadius / 16 * 2) - worldRadius / 16;
                    Chunk chunk = world.getChunkAt(chunkX, chunkZ = this.this$0.random.nextInt(worldRadius / 16 * 2) - worldRadius / 16);
                    if (!chunk.isLoaded()) {
                        chunk.load(true);
                    }
                    if (placed = this.this$0.attemptStructureGeneration(chunk)) {
                        ++this.structuresPlaced;
                    }
                    ++processedThisTick;
                    ++this.currentAttempt;
                }
                if (this.currentAttempt % 100 == 0 || this.currentAttempt == maxAttempts || this.structuresPlaced >= minStructures) {
                    this.this$0.plugin.getLogger().info("Structure generation progress: " + this.structuresPlaced + " structures placed, " + this.currentAttempt + "/" + maxAttempts + " attempts");
                }
                if (this.currentAttempt >= maxAttempts || this.structuresPlaced >= minStructures) {
                    this.this$0.plugin.getLogger().info("Structure generation complete for world: " + world.getName() + " - " + this.structuresPlaced + " structures placed");
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 1L, 1L);
    }

    public boolean attemptStructureGeneration(Chunk chunk) {
        org.bukkit.World world = chunk.getWorld();
        List disabledWorlds = this.plugin.getConfig().getStringList("disabled-worlds");
        if (disabledWorlds.contains(world.getName())) {
            return false;
        }
        double baseChance = this.plugin.getConfig().getDouble("generation.base-chance", 0.05);
        if (this.random.nextDouble() > baseChance) {
            return false;
        }
        ArrayList<CustomStructure> potentialStructures = new ArrayList<CustomStructure>();
        for (CustomStructure structure : this.structures.values()) {
            if (!(this.random.nextDouble() <= (switch (structure.getRarity()) {
                case StructureRarity.COMMON -> this.plugin.getConfig().getDouble("generation.rarity-weights.common", 0.7);
                case StructureRarity.RARE -> this.plugin.getConfig().getDouble("generation.rarity-weights.rare", 0.25);
                case StructureRarity.EPIC -> this.plugin.getConfig().getDouble("generation.rarity-weights.epic", 0.05);
                default -> 0.0;
            }))) continue;
            potentialStructures.add(structure);
        }
        if (potentialStructures.isEmpty()) {
            return false;
        }
        CustomStructure selectedStructure = (CustomStructure)potentialStructures.get(this.random.nextInt(potentialStructures.size()));
        Location location = this.findPlacementLocation(chunk, selectedStructure);
        if (location == null) {
            return false;
        }
        this.placeStructure(selectedStructure, location);
        return true;
    }

    private Location findPlacementLocation(Chunk chunk, CustomStructure structure) {
        int z;
        int x;
        int chunkX = chunk.getX() * 16;
        int chunkZ = chunk.getZ() * 16;
        org.bukkit.World world = chunk.getWorld();
        if (structure.isMultiChunk()) {
            boolean allChunksValid = true;
            for (x = 0; x < structure.getSizeX(); ++x) {
                for (z = 0; z < structure.getSizeZ(); ++z) {
                    Chunk adjacentChunk = world.getChunkAt(chunk.getX() + x, chunk.getZ() + z);
                    if (adjacentChunk.isLoaded()) continue;
                    try {
                        adjacentChunk.load(true);
                        continue;
                    }
                    catch (Exception e) {
                        this.plugin.getLogger().warning("Failed to load adjacent chunk for multi-chunk structure: " + e.getMessage());
                        allChunksValid = false;
                    }
                }
            }
            if (!allChunksValid) {
                return null;
            }
        }
        String biomeName = chunk.getBlock(8, 0, 8).getBiome().name();
        if (!structure.getBiomes().isEmpty() && !structure.getBiomes().contains(biomeName)) {
            return null;
        }
        switch (structure.getPlacement()) {
            case GROUND: {
                if (structure.isMultiChunk()) {
                    return this.findGroundMultiChunk(chunk, structure, world, chunkX, chunkZ);
                }
                x = chunkX + this.random.nextInt(16);
                z = chunkZ + this.random.nextInt(16);
                int y = world.getHighestBlockYAt(x, z);
                this.plugin.getLogger().info("[DEBUG] Finding GROUND placement in " + biomeName + " biome at X:" + x + " Z:" + z + " Y:" + y);
                return new Location(world, (double)x, (double)y, (double)z);
            }
            case AIR: {
                x = chunkX + this.random.nextInt(16);
                z = chunkZ + this.random.nextInt(16);
                int y = structure.getMinY() + this.random.nextInt(structure.getMaxY() - structure.getMinY() + 1);
                this.plugin.getLogger().info("[DEBUG] Finding AIR placement in " + biomeName + " biome at X:" + x + " Z:" + z + " Y:" + y);
                return new Location(world, (double)x, (double)y, (double)z);
            }
            case UNDERGROUND: {
                int maxY;
                if (structure.isMultiChunk()) {
                    return this.findUndergroundMultiChunk(chunk, structure, world, chunkX, chunkZ);
                }
                x = chunkX + this.random.nextInt(16);
                z = chunkZ + this.random.nextInt(16);
                int maxSurfaceY = world.getHighestBlockYAt(x, z);
                int minY = Math.max(structure.getMinY(), 5);
                if (minY >= (maxY = Math.min(structure.getMaxY(), maxSurfaceY - 5))) {
                    return null;
                }
                int y = minY + this.random.nextInt(maxY - minY + 1);
                this.plugin.getLogger().info("[DEBUG] Finding UNDERGROUND placement in " + biomeName + " biome at X:" + x + " Z:" + z + " Y:" + y);
                return new Location(world, (double)x, (double)y, (double)z);
            }
        }
        return null;
    }

    private Location findGroundMultiChunk(Chunk chunk, CustomStructure structure, org.bukkit.World world, int chunkX, int chunkZ) {
        int x = chunkX + 8;
        int z = chunkZ + 8;
        int centerY = world.getHighestBlockYAt(x, z);
        boolean isFlat = true;
        int maxHeightDiff = 5;
        for (int xOffset = 0; xOffset < structure.getSizeX() * 16; xOffset += 8) {
            for (int zOffset = 0; zOffset < structure.getSizeZ() * 16; zOffset += 8) {
                int checkX = chunkX + xOffset;
                int checkZ = chunkZ + zOffset;
                int checkY = world.getHighestBlockYAt(checkX, checkZ);
                if (Math.abs(checkY - centerY) <= maxHeightDiff) continue;
                isFlat = false;
                break;
            }
            if (!isFlat) break;
        }
        if (!isFlat) {
            return null;
        }
        this.plugin.getLogger().info("[DEBUG] Found suitable GROUND placement for multi-chunk structure at X:" + x + " Z:" + z + " Y:" + centerY);
        return new Location(world, (double)x, (double)centerY, (double)z);
    }

    private Location findUndergroundMultiChunk(Chunk chunk, CustomStructure structure, org.bukkit.World world, int chunkX, int chunkZ) {
        int maxY;
        int x = chunkX + 8;
        int z = chunkZ + 8;
        int minSurfaceY = Integer.MAX_VALUE;
        for (int xOffset = 0; xOffset < structure.getSizeX() * 16; xOffset += 8) {
            for (int zOffset = 0; zOffset < structure.getSizeZ() * 16; zOffset += 8) {
                int checkX = chunkX + xOffset;
                int checkZ = chunkZ + zOffset;
                int surfaceY = world.getHighestBlockYAt(checkX, checkZ);
                if (surfaceY >= minSurfaceY) continue;
                minSurfaceY = surfaceY;
            }
        }
        int minY = Math.max(structure.getMinY(), 5);
        if (minY >= (maxY = Math.min(structure.getMaxY(), minSurfaceY - 5))) {
            return null;
        }
        int y = minY + this.random.nextInt(maxY - minY + 1);
        this.plugin.getLogger().info("[DEBUG] Found suitable UNDERGROUND placement for multi-chunk structure at X:" + x + " Z:" + z + " Y:" + y);
        return new Location(world, (double)x, (double)y, (double)z);
    }

    private void placeStructure(final CustomStructure structure, final Location location) {
        this.plugin.getLogger().info("=== STRUCTURE PLACEMENT ===");
        this.plugin.getLogger().info("Structure: " + structure.getName() + " (" + String.valueOf((Object)structure.getRarity()) + ")");
        this.plugin.getLogger().info("Location: World=" + location.getWorld().getName() + ", X=" + location.getBlockX() + ", Y=" + location.getBlockY() + ", Z=" + location.getBlockZ());
        this.plugin.getLogger().info("Biome: " + location.getBlock().getBiome().name());
        this.plugin.getLogger().info("Schematic: " + structure.getSchematicName());
        this.plugin.getLogger().info("==========================");
        try {
            ClipboardFormat format;
            File schematicFile = new File(this.plugin.getSchematicsFolder(), structure.getSchematicName());
            if (!schematicFile.exists()) {
                if (structure.getSchematicName().endsWith(".schematic")) {
                    String schemName = structure.getSchematicName().replace(".schematic", ".schem");
                    schematicFile = new File(this.plugin.getSchematicsFolder(), schemName);
                } else if (structure.getSchematicName().endsWith(".schem")) {
                    String schematicName = structure.getSchematicName().replace(".schem", ".schematic");
                    schematicFile = new File(this.plugin.getSchematicsFolder(), schematicName);
                }
                if (!schematicFile.exists()) {
                    this.plugin.getLogger().warning("Schematic file not found: " + structure.getSchematicName());
                    return;
                }
            }
            if ((format = ClipboardFormats.findByFile((File)schematicFile)) == null) {
                this.plugin.getLogger().warning("Unknown schematic format: " + schematicFile.getName());
                return;
            }
            try (ClipboardReader reader = format.getReader((InputStream)new FileInputStream(schematicFile));){
                final Clipboard clipboard = reader.read();
                this.plugin.getLogger().info("Successfully loaded schematic: " + schematicFile.getName());
                if (schematicFile.getName().endsWith(".schematic")) {
                    this.plugin.getLogger().info("Using legacy .schematic format - applying block ID remapping");
                }
                final org.bukkit.World bukkitWorld = location.getWorld();
                new BukkitRunnable(this){
                    final /* synthetic */ StructureManager this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void run() {
                        try {
                            World worldEditWorld = BukkitAdapter.adapt((org.bukkit.World)bukkitWorld);
                            try (EditSession editSession = WorldEdit.getInstance().newEditSession(worldEditWorld);){
                                Operation operation = new ClipboardHolder(clipboard).createPaste((Extent)editSession).to(BlockVector3.at((int)location.getBlockX(), (int)location.getBlockY(), (int)location.getBlockZ())).ignoreAirBlocks(true).build();
                                Operations.complete((Operation)operation);
                                this.this$0.plugin.getLogger().info("Successfully pasted structure at X:" + location.getBlockX() + " Y:" + location.getBlockY() + " Z:" + location.getBlockZ());
                                this.this$0.applyStructureModifications(structure, location);
                            }
                        }
                        catch (Exception e) {
                            this.this$0.plugin.getLogger().log(Level.SEVERE, "Error during WorldEdit operation", e);
                        }
                    }
                }.runTask((Plugin)this.plugin);
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Error reading schematic file: " + e.getMessage());
                if (schematicFile.getName().endsWith(".schematic")) {
                    this.plugin.getLogger().info("Failed with .schematic, trying .schem format...");
                    File schemFile = new File(this.plugin.getSchematicsFolder(), structure.getSchematicName().replace(".schematic", ".schem"));
                    if (schemFile.exists()) {
                        this.placeStructure(structure, location);
                        return;
                    }
                }
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Error placing structure: " + structure.getName(), e);
        }
    }

    public Map<String, CustomStructure> getStructures() {
        return this.structures;
    }
}

