/*
 * Decompiled with CFR 0.152.
 */
package com.elthisboy.valentinesheartmod.blocks;

import com.elthisboy.valentinesheartmod.blocks.customs.BasketsModel;
import com.elthisboy.valentinesheartmod.blocks.customs.MiniTeddyBear;
import com.elthisboy.valentinesheartmod.blocks.customs.TeddyBear;
import com.elthisboy.valentinesheartmod.items.ModItem;
import java.util.function.Supplier;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CakeBlock;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModBlock {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"valentinesheart");
    public static final RegistryObject<Block> QUARTZ_ROSE_OVERWORLD_ORE = ModBlock.registerValentineBlock("quartz_rose_overworld_ore", () -> new DropExperienceBlock((IntProvider)UniformInt.of((int)2, (int)4), BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops()));
    public static final RegistryObject<Block> QUARTZ_ROSE_DEEPSLATE_ORE = ModBlock.registerValentineBlock("quartz_rose_deepslate_ore", () -> new DropExperienceBlock((IntProvider)UniformInt.of((int)2, (int)4), BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops()));
    public static final RegistryObject<Block> QUARTZ_ROSE_NETHER_ORE = ModBlock.registerValentineBlock("quartz_rose_nether_ore", () -> new DropExperienceBlock((IntProvider)UniformInt.of((int)2, (int)4), BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops()));
    public static final RegistryObject<Block> QUARTZ_ROSE_PILLAR = ModBlock.registerValentineBlock("quartz_rose_pillar", () -> new RotatedPillarBlock(BlockBehaviour.Properties.of().strength(3.0f, 3.0f).requiresCorrectToolForDrops()));
    public static final RegistryObject<Block> QUARTZ_ROSE_BLOCK = ModBlock.registerValentineBlock("quartz_rose_block", () -> new Block(BlockBehaviour.Properties.of().strength(3.0f, 3.0f).requiresCorrectToolForDrops()));
    public static final RegistryObject<Block> QUARTZ_ROSE_BRICKS = ModBlock.registerValentineBlock("quartz_rose_bricks", () -> new Block(BlockBehaviour.Properties.of().strength(3.0f, 3.0f).requiresCorrectToolForDrops()));
    public static final RegistryObject<Block> ROSE_CAKE = ModBlock.registerValentineBlock("rose_cake", () -> new CakeBlock(BlockBehaviour.Properties.of()));
    public static final RegistryObject<Block> TEDDYBEAR = ModBlock.registerValentineBlock("teddybear", () -> new TeddyBear(BlockBehaviour.Properties.of().strength(0.75f, 0.75f).noOcclusion()));
    public static final RegistryObject<Block> MINI_TEDDY_BEAR = ModBlock.registerValentineBlock("mini_teddy_bear", () -> new MiniTeddyBear(BlockBehaviour.Properties.of().strength(0.75f, 0.75f).noOcclusion()));
    public static final RegistryObject<Block> BASKETS = ModBlock.registerValentineBlock("baskets", () -> new BasketsModel(BlockBehaviour.Properties.of().strength(0.75f, 0.75f).noOcclusion()));

    public static <T extends Block> RegistryObject<T> registerValentineBlock(String name, Supplier<T> block) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        ModBlock.registerValentineBlockItem(name, toReturn);
        return toReturn;
    }

    public static <T extends Block> void registerValentineBlockItem(String name, RegistryObject<T> block) {
        ModItem.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register(IEventBus iEventBus) {
        BLOCKS.register(iEventBus);
    }
}

