/*
 * Decompiled with CFR 0.152.
 */
package com.elthisboy.valentinesheartmod.blocks.customs;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class HeartDecoration
extends HorizontalDirectionalBlock {
    public static final MapCodec<HeartDecoration> CODEC = HeartDecoration.simpleCodec(HeartDecoration::new);
    public static final VoxelShape NORTH_SHAPE = Block.box((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)15.0);
    public static final VoxelShape EAST_SHAPE = Block.box((double)1.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0);
    public static final VoxelShape SOUTH_SHAPE = Block.box((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0, (double)2.0);
    public static final VoxelShape WEST_SHAPE = Block.box((double)14.0, (double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0);

    public HeartDecoration(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.NORTH -> NORTH_SHAPE;
            case Direction.EAST -> EAST_SHAPE;
            case Direction.SOUTH -> SOUTH_SHAPE;
            case Direction.WEST -> WEST_SHAPE;
            default -> NORTH_SHAPE;
        };
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)pContext.getHorizontalDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{FACING});
    }
}

