/*
 * Decompiled with CFR 0.152.
 */
package com.elthisboy.valentinesheartmod.worldgen;

import com.elthisboy.valentinesheartmod.blocks.ModBlock;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;

public class ModConfiguredFeatures {
    public static final ResourceKey<ConfiguredFeature<?, ?>> OVERWORLD_QUARTZ_ROSE_ORE_KEY = ModConfiguredFeatures.registerKey("quartz_rose_overworld_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> NETHER_QUARTZ_ROSE_ORE_KEY = ModConfiguredFeatures.registerKey("quartz_rose_nether_ore");

    public static void bootstrap(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        TagMatchTest stoneReplaceables = new TagMatchTest(BlockTags.STONE_ORE_REPLACEABLES);
        TagMatchTest deepslateReplaceables = new TagMatchTest(BlockTags.DEEPSLATE_ORE_REPLACEABLES);
        BlockMatchTest netherrackReplaceables = new BlockMatchTest(Blocks.NETHERRACK);
        List<OreConfiguration.TargetBlockState> overworldAlexandriteOres = List.of(OreConfiguration.target((RuleTest)stoneReplaceables, (BlockState)((Block)ModBlock.QUARTZ_ROSE_OVERWORLD_ORE.get()).defaultBlockState()), OreConfiguration.target((RuleTest)deepslateReplaceables, (BlockState)((Block)ModBlock.QUARTZ_ROSE_DEEPSLATE_ORE.get()).defaultBlockState()));
        ModConfiguredFeatures.register(context, OVERWORLD_QUARTZ_ROSE_ORE_KEY, Feature.ORE, new OreConfiguration(overworldAlexandriteOres, 9));
        ModConfiguredFeatures.register(context, NETHER_QUARTZ_ROSE_ORE_KEY, Feature.ORE, new OreConfiguration((RuleTest)netherrackReplaceables, ((Block)ModBlock.QUARTZ_ROSE_NETHER_ORE.get()).defaultBlockState(), 9));
    }

    public static ResourceKey<ConfiguredFeature<?, ?>> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"valentinesheart", (String)name));
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(BootstrapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, F feature, FC configuration) {
        context.register(key, (Object)new ConfiguredFeature(feature, configuration));
    }
}

