/*
 * Decompiled with CFR 0.152.
 */
package mangopill.customized.client.event;

import mangopill.customized.client.event.renderer.BrewingBarrelBlockRenderer;
import mangopill.customized.client.event.renderer.CasseroleBlockRenderer;
import mangopill.customized.client.event.renderer.ModBrushableBlockRenderer;
import mangopill.customized.client.event.renderer.SoupBowlBlockRenderer;
import mangopill.customized.client.event.renderer.SoupBowlItemRenderer;
import mangopill.customized.client.event.tinting.Tinting;
import mangopill.customized.client.particle.AromaParticle;
import mangopill.customized.client.particle.DirtParticle;
import mangopill.customized.client.particle.SteamParticle;
import mangopill.customized.common.item.SoupBowlItem;
import mangopill.customized.common.registry.ModBlockEntityTypeRegistry;
import mangopill.customized.common.registry.ModBlockRegistry;
import mangopill.customized.common.registry.ModItemRegistry;
import mangopill.customized.common.registry.ModParticleTypeRegistry;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;

@EventBusSubscriber(modid="customized", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientEvent {
    @SubscribeEvent
    public static void registerOverride(FMLClientSetupEvent event) {
        event.enqueueWork(() -> ItemProperties.register((Item)ModItemRegistry.SOUP_BOWL.get(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"customized", (String)"drive"), (stack, level, player, seed) -> stack.getItem() instanceof SoupBowlItem ? (((SoupBowlItem)stack.getItem()).hasInput(stack) ? 1.0f : 0.0f) : 0.0f));
    }

    @SubscribeEvent
    public static void registerAdditional(ModelEvent.RegisterAdditional event) {
        event.register(ModelResourceLocation.standalone((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"customized", (String)"item/soup_bowl_with_drive_renderer")));
    }

    @SubscribeEvent
    public static void registerClientExtensions(RegisterClientExtensionsEvent event) {
        event.registerItem((IClientItemExtensions)new SoupBowlItemRenderer.SoupBowlItemExtensions(), new Item[]{ModItemRegistry.SOUP_BOWL.get()});
    }

    @SubscribeEvent
    public static void onRegisterRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer(ModBlockEntityTypeRegistry.SUSPICIOUS_DIRT.get(), ModBrushableBlockRenderer::new);
        event.registerBlockEntityRenderer(ModBlockEntityTypeRegistry.CASSEROLE.get(), CasseroleBlockRenderer::new);
        event.registerBlockEntityRenderer(ModBlockEntityTypeRegistry.SOUP_BOWL.get(), SoupBowlBlockRenderer::new);
        event.registerBlockEntityRenderer(ModBlockEntityTypeRegistry.BREWING_BARREL.get(), BrewingBarrelBlockRenderer::new);
    }

    @SubscribeEvent
    public static void registerParticleProviders(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)ModParticleTypeRegistry.DIRT.get(), DirtParticle.DirtParticleProvider::new);
        event.registerSpriteSet((ParticleType)ModParticleTypeRegistry.STEAM.get(), SteamParticle.SteamParticleProvider::new);
        event.registerSpriteSet((ParticleType)ModParticleTypeRegistry.AROMA.get(), AromaParticle.AromaParticleProvider::new);
    }

    @SubscribeEvent
    public static void registerBlockColorHandlers(RegisterColorHandlersEvent.Block event) {
        event.register((state, level, pos, tintIndex) -> level == null || pos == null ? -1 : Tinting.getPotWaterColor(level, state, pos), new Block[]{ModBlockRegistry.CASSEROLE.get()});
        event.register((state, level, pos, tintIndex) -> level == null || pos == null ? -1 : Tinting.getPlateBlockWaterColor(level, state, pos), new Block[]{ModBlockRegistry.SOUP_BOWL.get()});
    }

    @SubscribeEvent
    public static void registerItemColorHandlers(RegisterColorHandlersEvent.Item event) {
        event.register((stack, tintIndex) -> Tinting.getPlateItemWaterColor(stack), new ItemLike[]{(ItemLike)ModItemRegistry.SOUP_BOWL.get()});
    }
}

