/*
 * Decompiled with CFR 0.152.
 */
package mangopill.customized.client.event.tinting;

import java.util.List;
import mangopill.customized.client.util.ClientUtil;
import mangopill.customized.common.block.AbstractPlateBlock;
import mangopill.customized.common.block.AbstractPotBlock;
import mangopill.customized.common.block.entity.AbstractPlateBlockEntity;
import mangopill.customized.common.block.entity.AbstractPotBlockEntity;
import mangopill.customized.common.block.state.PlateState;
import mangopill.customized.common.block.state.PotState;
import mangopill.customized.common.item.SoupBowlItem;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class Tinting {
    public static int getPotWaterColor(BlockAndTintGetter getter, BlockState state, BlockPos pos) {
        Block block = state.getBlock();
        if (block instanceof AbstractPotBlock) {
            AbstractPotBlock potBlock = (AbstractPotBlock)block;
            if (!((PotState)((Object)state.getValue(AbstractPotBlock.LID))).equals((Object)PotState.WITH_DRIVE)) {
                return -1;
            }
            BlockEntity blockEntity = getter.getBlockEntity(pos);
            if (blockEntity instanceof AbstractPotBlockEntity) {
                AbstractPotBlockEntity potBlockEntity = (AbstractPotBlockEntity)blockEntity;
                List<ItemStack> stackList = potBlockEntity.getItemStackListInPot(false, true);
                return ClientUtil.getMaxValueColor(potBlockEntity.getLevel(), stackList);
            }
        }
        return -1;
    }

    public static int getPlateBlockWaterColor(BlockAndTintGetter getter, BlockState state, BlockPos pos) {
        if (state.getBlock() instanceof AbstractPlateBlock) {
            if (!((PlateState)((Object)state.getValue(AbstractPlateBlock.DRIVE))).equals((Object)PlateState.WITH_DRIVE)) {
                return -1;
            }
            BlockEntity blockEntity = getter.getBlockEntity(pos);
            if (blockEntity instanceof AbstractPlateBlockEntity) {
                AbstractPlateBlockEntity plateBlockEntity = (AbstractPlateBlockEntity)blockEntity;
                List<ItemStack> stackList = plateBlockEntity.getItemStackListInPlate(true);
                return ClientUtil.getMaxValueColor(plateBlockEntity.getLevel(), stackList);
            }
        }
        return -1;
    }

    public static int getPlateItemWaterColor(ItemStack stack) {
        SoupBowlItem soupBowlItem;
        Item item = stack.getItem();
        if (item instanceof SoupBowlItem && (soupBowlItem = (SoupBowlItem)item).hasInput(stack)) {
            List<ItemStack> stackList = soupBowlItem.getItemStackListInPlate(stack, true);
            if (Minecraft.getInstance().player != null) {
                return ClientUtil.getMaxValueColor((Level)Minecraft.getInstance().level, stackList);
            }
        }
        return -1;
    }
}

