/*
 * Decompiled with CFR 0.152.
 */
package mangopill.customized.client.event.tooltip;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.Collections;
import mangopill.customized.common.CustomizedConfig;
import mangopill.customized.common.FoodValue;
import mangopill.customized.common.tag.ModTag;
import mangopill.customized.common.util.PropertyValueUtil;
import mangopill.customized.common.util.category.NutrientCategory;
import mangopill.customized.common.util.value.PropertyValue;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(modid="customized", value={Dist.CLIENT})
public class PropertyValueTooltip {
    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        Player player = event.getEntity();
        ItemStack stack = event.getItemStack();
        if (player == null || player.level() == null) {
            return;
        }
        @NotNull PropertyValue propertyValue = PropertyValueUtil.getPropertyValue(stack, player.level());
        FoodProperties foodProperty = PropertyValueUtil.getFoodPropertyByPropertyValue(player.level(), Collections.singletonList(stack), false);
        if (propertyValue.isEmpty()) {
            return;
        }
        if (!PropertyValueTooltip.isCtrlKeyPressed() && PropertyValueTooltip.canShow()) {
            event.getToolTip().add(Component.translatable((String)"tooltip.customized.is_ctrl_key_pressed").withStyle(ChatFormatting.DARK_GRAY));
            return;
        }
        if (((Boolean)CustomizedConfig.SHOW_NUTRIENT_VALUE_TOOLTIP.get()).booleanValue()) {
            PropertyValueTooltip.addFoodCategory(event, stack);
            propertyValue.toSet().forEach(entry -> {
                MutableComponent propertyComponent = Component.translatable((String)"tooltip.customized.property_value", (Object[])new Object[]{Component.translatable((String)("property.customized.nutrient_category." + ((NutrientCategory)((Object)((Object)entry.getKey()))).getSerializedName())), entry.getValue()}).withStyle(Style.EMPTY.withColor(((NutrientCategory)((Object)((Object)entry.getKey()))).getColor())).append("%");
                event.getToolTip().add(propertyComponent);
            });
        }
        if (foodProperty.equals((Object)FoodValue.NULL)) {
            return;
        }
        if (((Boolean)CustomizedConfig.SHOW_ESTIMATED_VALUE_TOOLTIP.get()).booleanValue()) {
            MutableComponent estimatedComponent = Component.translatable((String)"tooltip.customized.estimated_value", (Object[])new Object[]{Component.translatable((String)"estimated.customized.nutritional_value"), foodProperty.nutrition(), Float.valueOf(foodProperty.saturation())}).withStyle(ChatFormatting.GREEN);
            event.getToolTip().add(estimatedComponent);
        }
        if (((Boolean)CustomizedConfig.SHOW_ESTIMATED_BUFF_TOOLTIP.get()).booleanValue() && !foodProperty.effects().isEmpty()) {
            foodProperty.effects().forEach(buff -> {
                MutableComponent estimatedBuff = Component.translatable((String)"tooltip.customized.estimated_buff", (Object[])new Object[]{Component.translatable((String)"estimated.customized.buff"), Component.translatable((String)((MobEffect)((MobEffectInstance)buff.effectSupplier().get()).getEffect().value()).getDescriptionId()), ((MobEffectInstance)buff.effectSupplier().get()).getDuration()}).withStyle(ChatFormatting.GREEN);
                event.getToolTip().add(estimatedBuff);
            });
        }
    }

    private static void addFoodCategory(ItemTooltipEvent event, ItemStack stack) {
        event.getToolTip().add(Component.translatable((String)("tooltip.customized" + (stack.is(ModTag.SEASONING) ? ".food_category_seasoning" : ".food_category_food"))).withStyle(ChatFormatting.BLUE));
    }

    private static boolean canShow() {
        return (Boolean)CustomizedConfig.SHOW_NUTRIENT_VALUE_TOOLTIP.get() != false || (Boolean)CustomizedConfig.SHOW_NUTRIENT_VALUE_TOOLTIP.get() != false || (Boolean)CustomizedConfig.SHOW_ESTIMATED_BUFF_TOOLTIP.get() != false;
    }

    private static boolean isCtrlKeyPressed() {
        return InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)341) || InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)345);
    }
}

