/*
 * Decompiled with CFR 0.152.
 */
package mangopill.customized.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class AromaParticle
extends TextureSheetParticle {
    public AromaParticle(ClientLevel level, double x, double y, double z, double ySpeed) {
        super(level, x, y, z, 0.0, ySpeed, 0.0);
        this.setSize(0.3f, 0.3f);
        this.scale(1.0f);
        this.lifetime = this.random.nextInt(40) + 40;
        this.gravity = 0.0f;
    }

    @NotNull
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ < this.lifetime) {
            double speedVariationY = ((double)this.random.nextFloat() - 0.5) * 0.02;
            this.yd += speedVariationY;
            this.yd *= (double)0.98f;
            float alphaFactor = 1.0f - (float)this.age / (float)this.lifetime;
            this.alpha = Math.max(0.0f, alphaFactor * 0.8f);
            this.move(0.0, this.yd, 0.0);
        } else {
            this.remove();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class AromaParticleProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public AromaParticleProvider(SpriteSet sprite) {
            this.sprite = sprite;
        }

        public Particle createParticle(@NotNull SimpleParticleType typeIn, @NotNull ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            AromaParticle particle = new AromaParticle(level, x, y, z, ySpeed);
            particle.setAlpha(0.8f);
            particle.pickSprite(this.sprite);
            return particle;
        }
    }
}

