/*
 * Decompiled with CFR 0.152.
 */
package mangopill.customized.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class DirtParticle
extends TextureSheetParticle {
    private final SpriteSet spriteSet;

    protected DirtParticle(ClientLevel level, double posX, double posY, double posZ, SpriteSet spriteSet) {
        super(level, posX, posY, posZ, 0.0, 0.0, 0.0);
        this.spriteSet = spriteSet;
        this.gravity = 1.0f;
        this.setSpriteFromAge(spriteSet);
    }

    public void tick() {
        this.setSpriteFromAge(this.spriteSet);
        super.tick();
    }

    @NotNull
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class DirtParticleProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public DirtParticleProvider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(@NotNull SimpleParticleType type, @NotNull ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new DirtParticle(level, x, y, z, this.spriteSet);
        }
    }
}

