/*
 * Decompiled with CFR 0.152.
 */
package mangopill.customized.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class SteamParticle
extends TextureSheetParticle {
    public SteamParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed);
        this.scale(2.0f);
        this.setSize(0.5f, 0.5f);
        this.lifetime = this.random.nextInt(35) + 35;
        this.gravity = this.random.nextFloat() + 0.2f;
    }

    @NotNull
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ < this.lifetime) {
            this.xd *= this.random.nextBoolean() ? 1.0 : -1.0;
            this.zd *= this.random.nextBoolean() ? 1.0 : -1.0;
            this.yd *= (double)this.gravity;
            float dampingFactor = 1.0f - (float)this.age / (float)this.lifetime;
            this.xd *= (double)dampingFactor;
            this.zd *= (double)dampingFactor;
            this.yd *= (double)dampingFactor;
            this.move(this.xd, this.yd, this.zd);
            if (this.alpha > 0.02f) {
                this.alpha -= 0.02f;
            }
        } else {
            this.remove();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class SteamParticleProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public SteamParticleProvider(SpriteSet sprite) {
            this.sprite = sprite;
        }

        public Particle createParticle(@NotNull SimpleParticleType typeIn, @NotNull ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            SteamParticle particle = new SteamParticle(level, x, y, z, xSpeed, ySpeed, zSpeed);
            particle.setAlpha(0.7f);
            particle.pickSprite(this.sprite);
            return particle;
        }
    }
}

