/*
 * Decompiled with CFR 0.152.
 */
package mangopill.customized.client.util;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import mangopill.customized.common.block.entity.AbstractPlateBlockEntity;
import mangopill.customized.common.block.entity.AbstractPotBlockEntity;
import mangopill.customized.common.block.entity.BrewingBarrelBlockEntity;
import mangopill.customized.common.item.AbstractPlateItem;
import mangopill.customized.common.util.PropertyValueUtil;
import mangopill.customized.common.util.category.NutrientCategory;
import mangopill.customized.common.util.value.PropertyValue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.StainedGlassPaneBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public final class ClientUtil {
    private ClientUtil() {
    }

    public static int getMaxValueColor(Level level, List<ItemStack> stackList) {
        HashMap<NutrientCategory, Float> nutrientSums = new HashMap<NutrientCategory, Float>();
        for (ItemStack stack : stackList) {
            @NotNull PropertyValue propertyValue = PropertyValueUtil.getPropertyValue(stack, level);
            if (propertyValue.isEmpty()) continue;
            for (Pair pair : propertyValue.toSet()) {
                NutrientCategory category = (NutrientCategory)((Object)pair.getKey());
                float value = ((Float)pair.getValue()).floatValue() * (float)stack.getCount();
                nutrientSums.put(category, Float.valueOf(nutrientSums.getOrDefault((Object)category, Float.valueOf(0.0f)).floatValue() + value));
            }
        }
        NutrientCategory maxCategory = null;
        double maxSum = 0.0;
        for (Map.Entry entry : nutrientSums.entrySet()) {
            if (!((double)((Float)entry.getValue()).floatValue() > maxSum)) continue;
            maxSum = ((Float)entry.getValue()).floatValue();
            maxCategory = (NutrientCategory)((Object)entry.getKey());
        }
        return maxCategory != null ? maxCategory.getColorWithAlpha() : -868256028;
    }

    public static void renderDrivePot(AbstractPotBlockEntity potBlockEntity, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay, float startLength, float startWidth, float startHeight, float endLength, float endWidth, float endHeight) {
        List<ItemStack> stackList = potBlockEntity.getItemStackListInPot(true, false);
        ClientUtil.renderDrive(potBlockEntity.getLevel(), stackList, poseStack, buffer, light, overlay, startLength, startWidth, startHeight, endLength, endWidth, endHeight);
    }

    public static void renderDrivePlate(AbstractPlateBlockEntity plateBlockEntity, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay, float startLength, float startWidth, float startHeight, float endLength, float endWidth, float endHeight) {
        List<ItemStack> stackList = plateBlockEntity.getItemStackListInPlate(false);
        ClientUtil.renderDrive(plateBlockEntity.getLevel(), stackList, poseStack, buffer, light, overlay, startLength, startWidth, startHeight, endLength, endWidth, endHeight);
    }

    public static void renderDrivePlateItem(ItemStack stack, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay, float startLength, float startWidth, float startHeight, float endLength, float endWidth, float endHeight) {
        Item item = stack.getItem();
        if (item instanceof AbstractPlateItem) {
            AbstractPlateItem plateItem = (AbstractPlateItem)item;
            List<ItemStack> stackList = plateItem.getItemStackListInPlate(stack, false);
            if (Minecraft.getInstance().player != null) {
                ClientUtil.renderDrive(Minecraft.getInstance().player.level(), stackList, poseStack, buffer, light, overlay, startLength, startWidth, startHeight, endLength, endWidth, endHeight);
            }
        }
    }

    public static void renderDrive(Level level, List<ItemStack> stackList, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay, float startLength, float startWidth, float startHeight, float endLength, float endWidth, float endHeight) {
        for (ItemStack stack : stackList) {
            ItemStack newStack = stack.copy();
            if (newStack.isEmpty()) continue;
            int count = newStack.getCount();
            int renderCount = count / 4;
            if (count % 4 > 0) {
                ++renderCount;
            }
            for (int i = 0; i < renderCount; ++i) {
                Random rand = new Random(stackList.lastIndexOf(stack));
                int seed = Item.getId((Item)newStack.getItem()) + rand.nextInt() + i;
                Random random = new Random(seed);
                float randX = startLength + random.nextFloat(endLength - startLength);
                float randY = startHeight + random.nextFloat(endHeight - startHeight);
                float randZ = startWidth + random.nextFloat(endWidth - startWidth);
                poseStack.pushPose();
                poseStack.translate(randX, randY, randZ);
                poseStack.mulPose(Axis.ZP.rotationDegrees(random.nextFloat(360.0f)));
                poseStack.mulPose(Axis.XP.rotationDegrees(random.nextFloat(360.0f)));
                poseStack.mulPose(Axis.YP.rotationDegrees(random.nextFloat(360.0f)));
                poseStack.scale(0.3f, 0.3f, 0.3f);
                if (level != null) {
                    ItemStack renderItemStack = newStack.copy();
                    renderItemStack.setCount(1);
                    Minecraft.getInstance().getItemRenderer().renderStatic(renderItemStack, ItemDisplayContext.FIXED, light, overlay, poseStack, buffer, null, seed);
                }
                poseStack.popPose();
            }
        }
    }

    public static void renderBrewingBarrel(Level level, BrewingBarrelBlockEntity barrelBlockEntity, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay, float startX, float startY, float startZ) {
        List<ItemStack> stackList = barrelBlockEntity.getItemStackListInBrewingBarrel(false);
        BlockState state = Objects.requireNonNull(barrelBlockEntity.getLevel()).getBlockState(barrelBlockEntity.getBlockPos());
        if (level == null) {
            return;
        }
        if (state.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            for (int i = 0; i < stackList.size(); ++i) {
                poseStack.pushPose();
                ItemStack itemStack = stackList.get(i);
                int col = i % 2;
                int row = i / 2;
                float x = startX + (float)col * startX;
                float y = startY + (float)row * startY;
                ClientUtil.adjust(poseStack, y, startZ, state, x, startZ);
                if (itemStack != null && !itemStack.isEmpty()) {
                    ItemStack renderItemStack = itemStack.copy();
                    renderItemStack.setCount(1);
                    Minecraft.getInstance().getItemRenderer().renderStatic(renderItemStack, ItemDisplayContext.FIXED, light, overlay, poseStack, buffer, null, 0);
                }
                poseStack.popPose();
            }
            ItemStack renderItemStack = barrelBlockEntity.getItemStackHandler().getStackInSlot(barrelBlockEntity.getInputSlot()).copy();
            renderItemStack.setCount(1);
            float x = 3.0f * startX;
            poseStack.pushPose();
            ClientUtil.adjust(poseStack, startY, startZ, state, x, startZ);
            if (!renderItemStack.isEmpty()) {
                renderItemStack.setCount(1);
                Minecraft.getInstance().getItemRenderer().renderStatic(renderItemStack, ItemDisplayContext.FIXED, light, overlay, poseStack, buffer, null, 0);
            }
            poseStack.popPose();
        }
    }

    private static void adjust(PoseStack poseStack, float startY, float startZ, BlockState state, float x, float z) {
        switch ((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            case NORTH: {
                z += 1.0f - 2.0f * startZ;
                break;
            }
            case SOUTH: {
                x = 1.0f - x;
                break;
            }
            case WEST: {
                z = 1.0f - x;
                x = 1.0f - startZ;
                break;
            }
            case EAST: {
                z = x;
                x = startZ;
            }
        }
        poseStack.translate(x, startY, z);
        poseStack.scale(0.1f, 0.1f, 0.1f);
        poseStack.mulPose(Axis.YP.rotationDegrees(360.0f - ((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).toYRot()));
    }

    public static void renderModel(@NotNull ItemStack stack, @NotNull ItemDisplayContext displayContext, @NotNull PoseStack poseStack, @NotNull MultiBufferSource multiBufferSource, int light, int overlay) {
        BlockItem blockItem;
        Block block;
        Item item;
        BakedModel model = Minecraft.getInstance().getItemRenderer().getItemModelShaper().getModelManager().getModel(ModelResourceLocation.standalone((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"customized", (String)"item/soup_bowl_with_drive_renderer")));
        boolean flag1 = displayContext != ItemDisplayContext.GUI && !displayContext.firstPerson() && (item = stack.getItem()) instanceof BlockItem ? !((block = (blockItem = (BlockItem)item).getBlock()) instanceof HalfTransparentBlock) && !(block instanceof StainedGlassPaneBlock) : true;
        for (BakedModel passModel : model.getRenderPasses(stack, flag1)) {
            for (RenderType renderType : passModel.getRenderTypes(stack, flag1)) {
                VertexConsumer vertexConsumer = flag1 ? ItemRenderer.getFoilBufferDirect((MultiBufferSource)multiBufferSource, (RenderType)renderType, (boolean)true, (boolean)stack.hasFoil()) : ItemRenderer.getFoilBuffer((MultiBufferSource)multiBufferSource, (RenderType)renderType, (boolean)true, (boolean)stack.hasFoil());
                Minecraft.getInstance().getItemRenderer().renderModelLists(passModel, stack, light, overlay, poseStack, vertexConsumer);
            }
        }
    }
}

