/*
 * Decompiled with CFR 0.152.
 */
package mangopill.customized.common.block;

import mangopill.customized.common.block.entity.AbstractPlateBlockEntity;
import mangopill.customized.common.block.state.PlateState;
import mangopill.customized.common.registry.ModParticleTypeRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractPlateBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final EnumProperty<PlateState> DRIVE = EnumProperty.create((String)"drive", PlateState.class);

    protected AbstractPlateBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue(DRIVE, (Comparable)((Object)PlateState.WITHOUT_DRIVE)));
    }

    public abstract VoxelShape setShapeWithoutDrive();

    public abstract VoxelShape setShapeWithDrive();

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        if (level.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof AbstractPlateBlockEntity) {
            AbstractPlateBlockEntity plateBlockEntity = (AbstractPlateBlockEntity)blockEntity;
            plateBlockEntity.eatFood(stack, level, player, state, pos);
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStateProperties.WATERLOGGED});
        builder.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING});
        builder.add(new Property[]{DRIVE});
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter getter, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return switch ((PlateState)((Object)state.getValue(DRIVE))) {
            default -> throw new MatchException(null, null);
            case PlateState.WITHOUT_DRIVE -> this.setShapeWithoutDrive();
            case PlateState.WITH_DRIVE -> this.setShapeWithDrive();
        };
    }

    @NotNull
    public VoxelShape getCollisionShape(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return switch ((PlateState)((Object)state.getValue(DRIVE))) {
            default -> throw new MatchException(null, null);
            case PlateState.WITHOUT_DRIVE -> this.setShapeWithoutDrive();
            case PlateState.WITH_DRIVE -> this.setShapeWithDrive();
        };
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        boolean hasWater = context.getLevel().getFluidState(context.getClickedPos()).getType().isSame((Fluid)Fluids.WATER);
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(hasWater))).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)context.getHorizontalDirection())).setValue(DRIVE, (Comparable)((Object)PlateState.WITHOUT_DRIVE));
    }

    @NotNull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @NotNull
    public BlockState updateShape(@NotNull BlockState state, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor level, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    public void animateTick(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof AbstractPlateBlockEntity && ((PlateState)((Object)state.getValue(DRIVE))).equals((Object)PlateState.WITH_DRIVE) && random.nextFloat() <= 0.3f) {
            double x = (double)pos.getX() + 0.2 + random.nextDouble() * 0.3;
            double y = (double)pos.getY() + 0.2;
            double z = (double)pos.getZ() + 0.2 + random.nextDouble() * 0.3;
            level.addParticle((ParticleOptions)ModParticleTypeRegistry.AROMA.get(), x, y, z, 0.0, 0.0, 0.0);
        }
    }

    @NotNull
    public ItemStack getCloneItemStack(@NotNull LevelReader level, @NotNull BlockPos pos, @NotNull BlockState state) {
        ItemStack itemStack;
        ItemStack stack = super.getCloneItemStack(level, pos, state);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof AbstractPlateBlockEntity) {
            AbstractPlateBlockEntity plateBlockEntity = (AbstractPlateBlockEntity)blockEntity;
            itemStack = plateBlockEntity.getCloneItemStack(stack);
        } else {
            itemStack = stack;
        }
        return itemStack;
    }
}

