/*
 * Decompiled with CFR 0.152.
 */
package mangopill.customized.common.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import javax.annotation.Nullable;
import mangopill.customized.common.block.AbstractPotBlock;
import mangopill.customized.common.block.entity.AbstractPotBlockEntity;
import mangopill.customized.common.block.entity.CasseroleBlockEntity;
import mangopill.customized.common.block.record.PotRecord;
import mangopill.customized.common.block.state.PotState;
import mangopill.customized.common.registry.ModItemRegistry;
import mangopill.customized.common.registry.ModSoundRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class CasseroleBlock
extends AbstractPotBlock {
    public static final MapCodec<CasseroleBlock> CODEC = CasseroleBlock.simpleCodec(CasseroleBlock::new);
    protected static final VoxelShape BLOCK_SHAPE_WITHOUT_LID = Shapes.or((VoxelShape)Block.box((double)13.0, (double)1.0, (double)3.0, (double)14.0, (double)3.0, (double)13.0), (VoxelShape[])new VoxelShape[]{Block.box((double)1.0, (double)3.0, (double)2.0, (double)2.0, (double)8.0, (double)14.0), Block.box((double)0.5, (double)8.0, (double)2.0, (double)1.5, (double)9.0, (double)14.0), Block.box((double)1.0, (double)8.0, (double)1.0, (double)2.0, (double)9.0, (double)2.0), Block.box((double)1.0, (double)8.0, (double)14.0, (double)2.0, (double)9.0, (double)15.0), Block.box((double)14.0, (double)8.0, (double)14.0, (double)15.0, (double)9.0, (double)15.0), Block.box((double)14.0, (double)8.0, (double)1.0, (double)15.0, (double)9.0, (double)2.0), Block.box((double)14.5, (double)8.0, (double)2.0, (double)15.5, (double)9.0, (double)14.0), Block.box((double)14.0, (double)3.0, (double)2.0, (double)15.0, (double)8.0, (double)14.0), Block.box((double)2.0, (double)8.0, (double)0.5, (double)14.0, (double)9.0, (double)1.5), Block.box((double)2.0, (double)8.0, (double)14.5, (double)14.0, (double)9.0, (double)15.5), Block.box((double)3.0, (double)1.0, (double)2.0, (double)13.0, (double)3.0, (double)3.0), Block.box((double)2.0, (double)3.0, (double)1.0, (double)14.0, (double)8.0, (double)2.0), Block.box((double)2.0, (double)3.0, (double)14.0, (double)14.0, (double)8.0, (double)15.0), Block.box((double)3.0, (double)1.0, (double)13.0, (double)13.0, (double)3.0, (double)14.0), Block.box((double)2.0, (double)1.0, (double)3.0, (double)3.0, (double)3.0, (double)13.0), Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0), Block.box((double)2.0, (double)2.0, (double)2.0, (double)3.0, (double)3.0, (double)3.0), Block.box((double)2.0, (double)2.0, (double)13.0, (double)3.0, (double)3.0, (double)14.0), Block.box((double)13.0, (double)2.0, (double)13.0, (double)14.0, (double)3.0, (double)14.0), Block.box((double)13.0, (double)2.0, (double)2.0, (double)14.0, (double)3.0, (double)3.0)});
    protected static final VoxelShape BLOCK_SHAPE_WITH_LID = Shapes.or((VoxelShape)BLOCK_SHAPE_WITHOUT_LID, (VoxelShape[])new VoxelShape[]{Block.box((double)12.0, (double)8.0, (double)4.0, (double)14.0, (double)8.5, (double)12.0), Block.box((double)2.0, (double)8.0, (double)2.0, (double)14.0, (double)8.5, (double)4.0), Block.box((double)4.0, (double)8.5, (double)4.0, (double)12.0, (double)9.0, (double)12.0), Block.box((double)2.0, (double)8.0, (double)4.0, (double)4.0, (double)8.5, (double)12.0), Block.box((double)2.0, (double)8.0, (double)12.0, (double)14.0, (double)8.5, (double)14.0), Block.box((double)6.5, (double)9.5, (double)6.5, (double)9.5, (double)10.0, (double)9.5), Block.box((double)7.0, (double)9.5, (double)7.0, (double)9.0, (double)10.5, (double)9.0), Block.box((double)7.0, (double)9.0, (double)7.0, (double)9.0, (double)9.5, (double)9.0)});

    public CasseroleBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public void animateTick(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        CasseroleBlockEntity cookingPotEntity;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CasseroleBlockEntity && (cookingPotEntity = (CasseroleBlockEntity)blockEntity).isHeated() && !((PotState)((Object)state.getValue((Property)LID))).equals((Object)PotState.WITHOUT_LID)) {
            double x = (double)pos.getX() + 0.4;
            double y = pos.getY();
            double z = (double)pos.getZ() + 0.4;
            if (random.nextInt(8) == 0) {
                SoundEvent sound = ((PotState)((Object)state.getValue((Property)LID))).equals((Object)PotState.WITH_LID) ? ModSoundRegistry.BOILING_WATER_WITH_LID.get() : ModSoundRegistry.BOILING_WATER_WITHOUT_LID.get();
                level.playLocalSound(x, y, z, sound, SoundSource.BLOCKS, random.nextFloat() + 0.3f, 0.8f, false);
            }
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> blockEntityType) {
        if (!((PotState)((Object)state.getValue((Property)LID))).equals((Object)PotState.WITHOUT_LID)) {
            if (level.isClientSide) {
                return CasseroleBlock.createTickerHelper(blockEntityType, PotRecord.CASSEROLE.entityType(), AbstractPotBlockEntity::animationTick);
            }
            return CasseroleBlock.createTickerHelper(blockEntityType, PotRecord.CASSEROLE.entityType(), AbstractPotBlockEntity::cookingTick);
        }
        return null;
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return PotRecord.CASSEROLE.entityType().create(pos, state);
    }

    @NotNull
    public List<ItemStack> getDrops(@NotNull BlockState state, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull LootParams.Builder builder) {
        if (((PotState)((Object)state.getValue((Property)LID))).equals((Object)PotState.WITH_LID)) {
            List getDrops = super.getDrops(state, builder);
            getDrops.add(new ItemStack((ItemLike)ModItemRegistry.CASSEROLE_ILD.get()));
            return getDrops;
        }
        return super.getDrops(state, builder);
    }

    @Override
    @NotNull
    public VoxelShape setShapeWithoutLid() {
        return BLOCK_SHAPE_WITHOUT_LID;
    }

    @Override
    @NotNull
    public VoxelShape setShapeWithLid() {
        return BLOCK_SHAPE_WITH_LID;
    }

    @Override
    @NotNull
    public VoxelShape setShapeWithDrive() {
        return BLOCK_SHAPE_WITHOUT_LID;
    }
}

