/*
 * Decompiled with CFR 0.152.
 */
package mangopill.customized.common.block;

import mangopill.customized.common.registry.ModItemRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class FamousDishBlock
extends Block {
    public static final IntegerProperty EAT = IntegerProperty.create((String)"eat", (int)0, (int)2);
    protected static final VoxelShape SHAPE = Shapes.or((VoxelShape)Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)1.0, (double)12.0), (VoxelShape[])new VoxelShape[]{Block.box((double)3.0, (double)1.0, (double)4.0, (double)4.0, (double)3.0, (double)12.0), Block.box((double)3.0, (double)1.0, (double)12.0, (double)13.0, (double)3.0, (double)13.0), Block.box((double)3.0, (double)3.0, (double)2.0, (double)13.0, (double)6.0, (double)3.0), Block.box((double)2.0, (double)3.0, (double)3.0, (double)3.0, (double)6.0, (double)13.0), Block.box((double)13.0, (double)3.0, (double)3.0, (double)14.0, (double)6.0, (double)13.0), Block.box((double)3.0, (double)3.0, (double)13.0, (double)13.0, (double)6.0, (double)14.0), Block.box((double)3.0, (double)1.0, (double)3.0, (double)13.0, (double)3.0, (double)4.0), Block.box((double)12.0, (double)1.0, (double)4.0, (double)13.0, (double)3.0, (double)12.0)});
    private final FoodProperties foodProperties;

    public FamousDishBlock(BlockBehaviour.Properties properties, FoodProperties foodProperties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)EAT, (Comparable)Integer.valueOf(0)));
        this.foodProperties = foodProperties;
    }

    @NotNull
    public ItemInteractionResult useItemOn(@NotNull ItemStack itemStackInHand, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult result) {
        if (level.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        if (this.foodProperties != null) {
            int eat = (Integer)state.getValue((Property)EAT);
            if (eat < 2) {
                this.eat(level, player, pos);
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)EAT, (Comparable)Integer.valueOf(eat + 1)));
            } else {
                if (!player.getInventory().add(ModItemRegistry.FAMOUS_DISH_PLATE.get().getDefaultInstance())) {
                    player.drop(ModItemRegistry.FAMOUS_DISH_PLATE.get().getDefaultInstance(), false);
                }
                level.playSound(null, pos, SoundEvents.STONE_BREAK, SoundSource.PLAYERS, 0.8f, 1.0f);
                level.removeBlock(pos, false);
            }
        }
        return ItemInteractionResult.SUCCESS;
    }

    protected void eat(Level level, Player player, BlockPos pos) {
        player.getFoodData().eat(this.foodProperties);
        for (FoodProperties.PossibleEffect effect : this.foodProperties.effects()) {
            if (level.isClientSide || effect == null || !(level.random.nextFloat() < effect.probability())) continue;
            player.addEffect(effect.effect());
        }
        level.playSound(null, pos, SoundEvents.GENERIC_EAT, SoundSource.PLAYERS, 0.8f, 1.0f);
    }

    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING});
        builder.add(new Property[]{EAT});
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter getter, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return SHAPE;
    }

    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)context.getHorizontalDirection())).setValue((Property)EAT, (Comparable)Integer.valueOf(0));
    }

    public FoodProperties getFoodProperties() {
        return this.foodProperties;
    }
}

