/*
 * Decompiled with CFR 0.152.
 */
package mangopill.customized.common.block;

import mangopill.customized.common.registry.ModItemRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class SaltPanBlock
extends Block {
    public static final BooleanProperty WITH_WATER = BooleanProperty.create((String)"with_water");
    protected static final VoxelShape SHAPE = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)0.0, (double)1.0, (double)0.0, (double)1.0, (double)2.0, (double)16.0), Block.box((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)2.0, (double)1.0), Block.box((double)1.0, (double)1.0, (double)15.0, (double)15.0, (double)2.0, (double)16.0), Block.box((double)15.0, (double)1.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0)});

    public SaltPanBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)WITH_WATER, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH));
    }

    @NotNull
    public ItemInteractionResult useItemOn(@NotNull ItemStack itemStackInHand, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult result) {
        if (level.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        if (((Boolean)state.getValue((Property)WITH_WATER)).equals(false)) {
            this.shrinkAndGive(itemStackInHand, state, level, pos, player, Items.POTION, Items.GLASS_BOTTLE, SoundEvents.BOTTLE_EMPTY, true);
        } else {
            this.shrinkAndGive(itemStackInHand, state, level, pos, player, Items.GLASS_BOTTLE, Items.POTION, SoundEvents.BOTTLE_FILL, false);
        }
        return ItemInteractionResult.SUCCESS;
    }

    protected void shrinkAndGive(ItemStack itemStackInHand, BlockState state, Level level, BlockPos pos, Player player, Item shrinkItem, Item giveItem, SoundEvent sound, boolean with_water) {
        if (itemStackInHand.is(shrinkItem)) {
            if (!player.isCreative()) {
                itemStackInHand.shrink(1);
                if (!player.getInventory().add(giveItem.getDefaultInstance())) {
                    player.drop(giveItem.getDefaultInstance(), false);
                }
            }
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)WITH_WATER, (Comparable)Boolean.valueOf(with_water)));
            level.playSound(null, pos, sound, SoundSource.BLOCKS, 0.8f, 1.0f);
        }
    }

    protected void tick(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        if (!level.canSeeSky(pos) || !level.isDay() || ((Boolean)state.getValue((Property)WITH_WATER)).equals(false)) {
            level.scheduleTick(pos, (Block)this, Math.max(10000, RandomSource.create().nextInt(13000)));
            return;
        }
        level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)WITH_WATER, (Comparable)Boolean.valueOf(false)));
        ItemEntity itemEntity = new ItemEntity((Level)level, (double)pos.getX(), (double)pos.getY() + 0.5, (double)pos.getZ(), ModItemRegistry.SALT.get().getDefaultInstance());
        itemEntity.setDeltaMovement(0.0, 0.01, 0.0);
        level.addFreshEntity((Entity)itemEntity);
    }

    public void onPlace(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean isMoving) {
        level.scheduleTick(pos, (Block)this, Math.max(10000, RandomSource.create().nextInt(13000)));
    }

    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING});
        builder.add(new Property[]{WITH_WATER});
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter getter, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return SHAPE;
    }

    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)context.getHorizontalDirection())).setValue((Property)WITH_WATER, (Comparable)Boolean.valueOf(false));
    }
}

