/*
 * Decompiled with CFR 0.152.
 */
package mangopill.customized.common.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.CommonHooks;
import org.jetbrains.annotations.NotNull;

public abstract class TallWaterloggedCropBlock
extends BushBlock
implements BonemealableBlock,
SimpleWaterloggedBlock {
    public static final IntegerProperty AGE = BlockStateProperties.AGE_7;
    public static final BooleanProperty GROW_PLACED = BooleanProperty.create((String)"grow_placed");
    private final int topMaxAge = 7;
    private final int bottomMaxAge;

    public TallWaterloggedCropBlock(BlockBehaviour.Properties properties, int bottomMaxAge) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true))).setValue((Property)GROW_PLACED, (Comparable)Boolean.valueOf(false)));
        this.bottomMaxAge = bottomMaxAge;
    }

    public abstract VoxelShape[] setShapeByAge();

    public abstract int setGrowChance(BlockState var1, BlockGetter var2, BlockPos var3);

    public void randomTick(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        super.tick(state, level, pos, random);
        if (level.getRawBrightness(pos.above(), 0) < 6 || !level.isAreaLoaded(pos, 1)) {
            return;
        }
        if (!CommonHooks.canCropGrow((Level)level, (BlockPos)pos, (BlockState)state, (random.nextInt(this.setGrowChance(state, (BlockGetter)level, pos)) == 0 ? 1 : 0) != 0)) {
            return;
        }
        if (this.isTop(state)) {
            int topAge = (Integer)state.getValue((Property)AGE);
            if (topAge >= 7) {
                return;
            }
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(topAge + 1)));
            CommonHooks.fireCropGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
        } else {
            int age = (Integer)state.getValue((Property)AGE);
            if (age >= this.bottomMaxAge) {
                if (!level.isEmptyBlock(pos.above())) {
                    return;
                }
                level.setBlockAndUpdate(pos.above(), (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)AGE, (Comparable)Integer.valueOf(this.bottomMaxAge + 1))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)GROW_PLACED, (Comparable)Boolean.valueOf(true)));
                return;
            }
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(age + 1)));
            CommonHooks.fireCropGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    public boolean isValidBonemealTarget(@NotNull LevelReader levelReader, @NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        if (this.isTop(blockState)) {
            return (Integer)blockState.getValue((Property)AGE) < 7;
        }
        BlockState stateAbove = levelReader.getBlockState(blockPos.above());
        return stateAbove.getBlock() == this ? (Integer)stateAbove.getValue((Property)AGE) != 7 : (Integer)blockState.getValue((Property)AGE) <= this.bottomMaxAge;
    }

    public boolean isBonemealSuccess(@NotNull Level level, @NotNull RandomSource randomSource, @NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return true;
    }

    public void performBonemeal(@NotNull ServerLevel serverLevel, @NotNull RandomSource randomSource, @NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        int bottomAge = (Integer)blockState.getValue((Property)AGE);
        int newBottomAge = Math.min(bottomAge + Mth.nextInt((RandomSource)randomSource, (int)1, (int)3), this.bottomMaxAge);
        if (!this.isTop(blockState) && bottomAge < this.bottomMaxAge) {
            serverLevel.setBlockAndUpdate(blockPos, (BlockState)blockState.setValue((Property)AGE, (Comparable)Integer.valueOf(newBottomAge)));
        } else if (this.isTop(blockState)) {
            int topAge = (Integer)blockState.getValue((Property)AGE);
            int newTopAge = Math.min(topAge + Mth.nextInt((RandomSource)randomSource, (int)1, (int)3), 7);
            serverLevel.setBlockAndUpdate(blockPos, (BlockState)blockState.setValue((Property)AGE, (Comparable)Integer.valueOf(newTopAge)));
        } else {
            BlockPos posAbove = blockPos.above();
            BlockState stateAbove = serverLevel.getBlockState(posAbove);
            if (serverLevel.isEmptyBlock(posAbove)) {
                serverLevel.setBlockAndUpdate(posAbove, (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)AGE, (Comparable)Integer.valueOf(this.bottomMaxAge + 1))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)GROW_PLACED, (Comparable)Boolean.valueOf(true)));
            } else if (stateAbove.getBlock() == this) {
                int newTopAge = Math.min(Math.max((Integer)stateAbove.getValue((Property)AGE), this.bottomMaxAge) + Mth.nextInt((RandomSource)randomSource, (int)1, (int)(7 - this.bottomMaxAge)), 7);
                serverLevel.setBlockAndUpdate(posAbove, (BlockState)stateAbove.setValue((Property)AGE, (Comparable)Integer.valueOf(newTopAge)));
            }
        }
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return this.setShapeByAge()[(Integer)state.getValue((Property)AGE)];
    }

    public boolean canSurvive(@NotNull BlockState state, LevelReader level, @NotNull BlockPos pos) {
        FluidState fluid = level.getFluidState(pos);
        BlockState stateBelow = level.getBlockState(pos.below());
        if (stateBelow.getBlock() instanceof TallWaterloggedCropBlock && ((Boolean)state.getValue((Property)GROW_PLACED)).booleanValue()) {
            return !this.isTop(stateBelow);
        }
        return super.canSurvive(state, level, pos) && fluid.is(FluidTags.WATER) && fluid.isSource();
    }

    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{AGE, BlockStateProperties.WATERLOGGED, GROW_PLACED});
    }

    @NotNull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @NotNull
    public BlockState updateShape(@NotNull BlockState state, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor level, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    public boolean isTop(BlockState state) {
        return (Integer)state.getValue((Property)AGE) > this.bottomMaxAge;
    }
}

