/*
 * Decompiled with CFR 0.152.
 */
package mangopill.customized.common.block.entity;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import javax.annotation.Nullable;
import mangopill.customized.common.FoodValue;
import mangopill.customized.common.block.AbstractPlateBlock;
import mangopill.customized.common.block.state.PlateState;
import mangopill.customized.common.item.AbstractPlateItem;
import mangopill.customized.common.registry.ModDataComponentRegistry;
import mangopill.customized.common.util.CreateItemStackHandler;
import mangopill.customized.common.util.ModItemStackHandlerHelper;
import mangopill.customized.common.util.record.ConsumptionCountRecord;
import mangopill.customized.common.util.record.ConsumptionCountTotalRecord;
import mangopill.customized.common.util.record.ItemStackHandlerRecord;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractPlateBlockEntity
extends BlockEntity
implements CreateItemStackHandler {
    private final int ingredientInput;
    private final int seasoningInput;
    private static final int SPICE_INPUT = 1;
    private final int allSlot;
    private final ItemStackHandler itemStackHandler;
    private FoodProperties foodProperty;
    private int consumptionCount;
    private int consumptionCountTotal;

    public AbstractPlateBlockEntity(BlockEntityType<? extends AbstractPlateBlockEntity> type, BlockPos pos, BlockState blockState, int ingredientInput, int seasoningInput) {
        super(type, pos, blockState);
        this.ingredientInput = ingredientInput;
        this.seasoningInput = seasoningInput;
        this.allSlot = ingredientInput + seasoningInput + 1;
        this.itemStackHandler = this.createItemStackHandler(this.allSlot);
    }

    @Override
    public void itemStackHandlerChanged() {
        super.setChanged();
        if (this.level != null) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
        }
    }

    public boolean hasInput() {
        return ModItemStackHandlerHelper.hasInput(this.itemStackHandler, this.allSlot);
    }

    public List<ItemStack> getItemStackListInPlate(boolean includeSeasoningAndSpice) {
        return includeSeasoningAndSpice ? ModItemStackHandlerHelper.getItemStackListInSlot(this.itemStackHandler, 0, this.allSlot) : ModItemStackHandlerHelper.getItemStackListInSlot(this.itemStackHandler, 0, this.ingredientInput);
    }

    public void eatFood(@NotNull ItemStack stack, @NotNull Level level, @NotNull Player player, @NotNull BlockState state, @NotNull BlockPos pos) {
        if (this.consumptionCount >= 1) {
            level.playSound(null, player.getX(), player.getY(), player.getZ(), player.getEatingSound(stack), SoundSource.NEUTRAL, 1.0f, 1.0f + (level.random.nextFloat() - level.random.nextFloat()) * 0.4f);
            player.getFoodData().eat(this.foodProperty);
            AbstractPlateBlockEntity.addEffect((LivingEntity)player, this.foodProperty);
            AbstractPlateItem.plateAdvancement((LivingEntity)player, this.foodProperty);
            if (this.consumptionCount > 1) {
                ModItemStackHandlerHelper.reduceItemStackCountByDivision(this.itemStackHandler, this.consumptionCountTotal);
            } else {
                ModItemStackHandlerHelper.clearAllSlot(this.itemStackHandler);
                this.clearFoodPropertyAndCountTotal();
                level.setBlockAndUpdate(pos, (BlockState)state.setValue(AbstractPlateBlock.DRIVE, (Comparable)((Object)PlateState.WITHOUT_DRIVE)));
            }
            --this.consumptionCount;
            player.gameEvent((Holder)GameEvent.EAT);
            this.itemStackHandlerChanged();
        }
    }

    public static void addEffect(LivingEntity livingEntity, FoodProperties foodProperties) {
        if (!livingEntity.level().isClientSide()) {
            for (FoodProperties.PossibleEffect foodproperties$possibleeffect : foodProperties.effects()) {
                if (!(livingEntity.getRandom().nextFloat() < foodproperties$possibleeffect.probability())) continue;
                livingEntity.addEffect(foodproperties$possibleeffect.effect());
            }
            if (foodProperties.equals((Object)FoodValue.INEDIBLE)) {
                livingEntity.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 500, 1));
            }
        }
    }

    public void clearFoodPropertyAndCountTotal() {
        this.foodProperty = FoodValue.NULL;
        this.consumptionCount = 0;
    }

    @NotNull
    public ItemStack getCloneItemStack(ItemStack stack) {
        ItemStack itemStack = new ItemStack((ItemLike)stack.getItem());
        itemStack.applyComponents(this.collectComponents());
        return itemStack;
    }

    public CompoundTag @NotNull [] getFoodPropertyTagWrapper() {
        CompoundTag[] foodPropertyTagWrapper = new CompoundTag[1];
        DataResult encodeResult = FoodProperties.DIRECT_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.foodProperty);
        encodeResult.result().ifPresent(tag -> {
            if (tag instanceof CompoundTag) {
                foodPropertyTagWrapper[0] = (CompoundTag)tag;
            }
        });
        return foodPropertyTagWrapper;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void loadAdditional(@NotNull CompoundTag compound, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(compound, registries);
        this.consumptionCount = compound.getInt("ConsumptionCount");
        this.consumptionCountTotal = compound.getInt("ConsumptionCountTotal");
        this.itemStackHandler.deserializeNBT(registries, compound.getCompound("ItemStackHandler"));
        if (compound.contains("FoodProperty")) {
            CompoundTag foodPropertyTag = compound.getCompound("FoodProperty");
            DataResult decodeResult = FoodProperties.DIRECT_CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)foodPropertyTag);
            decodeResult.result().ifPresent(pair -> {
                Tag tag = (Tag)pair.getSecond();
                if (tag instanceof CompoundTag) {
                    this.foodProperty = (FoodProperties)FoodProperties.DIRECT_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag).getOrThrow();
                }
            });
        } else {
            this.foodProperty = FoodValue.NULL;
        }
    }

    public void saveAdditional(@NotNull CompoundTag compound, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(compound, registries);
        compound.putInt("ConsumptionCount", this.consumptionCount);
        compound.putInt("ConsumptionCountTotal", this.consumptionCountTotal);
        compound.put("ItemStackHandler", (Tag)this.itemStackHandler.serializeNBT(registries));
        CompoundTag[] foodPropertyTagWrapper = this.getFoodPropertyTagWrapper();
        compound.put("FoodProperty", (Tag)foodPropertyTagWrapper[0]);
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        super.saveAdditional(tag, registries);
        tag.putInt("ConsumptionCount", this.consumptionCount);
        tag.putInt("ConsumptionCountTotal", this.consumptionCountTotal);
        tag.put("ItemStackHandler", (Tag)this.itemStackHandler.serializeNBT(registries));
        CompoundTag[] foodPropertyTagWrapper = this.getFoodPropertyTagWrapper();
        tag.put("FoodProperty", (Tag)foodPropertyTagWrapper[0]);
        return tag;
    }

    public void removeComponentsFromTag(CompoundTag tag) {
        tag.remove("ConsumptionCount");
        tag.remove("ConsumptionCountTotal");
        tag.remove("ItemStackHandler");
        tag.remove("FoodProperty");
    }

    protected void collectImplicitComponents(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull DataComponentMap.Builder component) {
        super.collectImplicitComponents(component);
        if (this.hasInput()) {
            component.set(ModDataComponentRegistry.CONSUMPTION_COUNT, (Object)new ConsumptionCountRecord(this.consumptionCount));
            component.set(ModDataComponentRegistry.CONSUMPTION_COUNT_TOTAL, (Object)new ConsumptionCountTotalRecord(this.consumptionCountTotal));
            component.set(DataComponents.FOOD, (Object)this.foodProperty);
            component.set(ModDataComponentRegistry.ITEM_STACK_HANDLER, (Object)new ItemStackHandlerRecord(this.itemStackHandler));
        }
    }

    protected void applyImplicitComponents(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        this.consumptionCount = ((ConsumptionCountRecord)componentInput.getOrDefault(ModDataComponentRegistry.CONSUMPTION_COUNT, (Object)ConsumptionCountRecord.NULL)).consumptionCount();
        this.consumptionCountTotal = ((ConsumptionCountTotalRecord)componentInput.getOrDefault(ModDataComponentRegistry.CONSUMPTION_COUNT_TOTAL, (Object)ConsumptionCountTotalRecord.NULL)).consumptionCountTotal();
        this.foodProperty = (FoodProperties)componentInput.getOrDefault(DataComponents.FOOD, (Object)FoodValue.NULL);
        ItemStackHandler componentItemStackHandler = ((ItemStackHandlerRecord)componentInput.getOrDefault(ModDataComponentRegistry.ITEM_STACK_HANDLER, (Object)ItemStackHandlerRecord.NULL)).itemStackHandler();
        List<ItemStack> stackList = ModItemStackHandlerHelper.getItemStackListInSlot(componentItemStackHandler, 0, this.allSlot);
        stackList.forEach(stack -> ModItemStackHandlerHelper.insertItem(stack.copy(), this.itemStackHandler, this.ingredientInput, this.seasoningInput, this.allSlot));
        this.itemStackHandlerChanged();
    }

    public int getIngredientInput() {
        return this.ingredientInput;
    }

    public int getSeasoningInput() {
        return this.seasoningInput;
    }

    public ItemStackHandler getItemStackHandler() {
        return this.itemStackHandler;
    }

    public FoodProperties getFoodProperty() {
        return this.foodProperty;
    }

    public int getConsumptionCountTotal() {
        return this.consumptionCountTotal;
    }

    public int getConsumptionCount() {
        return this.consumptionCount;
    }
}

