/*
 * Decompiled with CFR 0.152.
 */
package mangopill.customized.common.block.entity;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import mangopill.customized.common.CustomizedConfig;
import mangopill.customized.common.block.AbstractPotBlock;
import mangopill.customized.common.block.handler.PotItemHandler;
import mangopill.customized.common.block.state.PotState;
import mangopill.customized.common.recipe.AbstractPotRecipe;
import mangopill.customized.common.registry.ModAdvancementRegistry;
import mangopill.customized.common.tag.ModTag;
import mangopill.customized.common.util.CreateItemStackHandler;
import mangopill.customized.common.util.ModItemStackHandlerHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.RecipeWrapper;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractPotBlockEntity
extends BlockEntity
implements CreateItemStackHandler {
    private final int ingredientInput;
    private final int seasoningInput;
    private static final int SPICE_INPUT = 1;
    private static final int OUTPUT = 1;
    private final int allSlot;
    private final ItemStackHandler itemStackHandler;
    private final IItemHandler inputHandler;
    private final IItemHandler outputHandler;
    private final RecipeManager.CachedCheck<RecipeWrapper, ? extends AbstractPotRecipe> potCheck;
    private final RecipeManager.CachedCheck<SingleRecipeInput, CampfireCookingRecipe> campfireCheck;
    private int cookingTime;
    private int cookingCompletionTime;

    public AbstractPotBlockEntity(BlockEntityType<? extends AbstractPotBlockEntity> type, BlockPos pos, BlockState blockState, int ingredientCount, int seasoningCount, RecipeManager.CachedCheck<RecipeWrapper, ? extends AbstractPotRecipe> potCheck) {
        super(type, pos, blockState);
        this.ingredientInput = ingredientCount;
        this.seasoningInput = seasoningCount;
        this.allSlot = this.ingredientInput + this.seasoningInput + 1 + 1;
        this.campfireCheck = RecipeManager.createCheck((RecipeType)RecipeType.CAMPFIRE_COOKING);
        this.itemStackHandler = this.createItemStackHandler(this.allSlot);
        this.inputHandler = new PotItemHandler((IItemHandler)this.itemStackHandler, Direction.UP, ingredientCount, seasoningCount);
        this.outputHandler = new PotItemHandler((IItemHandler)this.itemStackHandler, Direction.DOWN, ingredientCount, seasoningCount);
        this.potCheck = potCheck;
    }

    @Override
    public void itemStackHandlerChanged() {
        super.setChanged();
        if (this.level != null) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
        }
    }

    public static void cookingTick(Level level, BlockPos pos, BlockState state, AbstractPotBlockEntity potBlockEntity) {
        RecipeWrapper wrapper = new RecipeWrapper((IItemHandler)potBlockEntity.itemStackHandler);
        Optional<RecipeHolder<? extends AbstractPotRecipe>> potMatchRecipe = potBlockEntity.getPotMatchRecipe(wrapper);
        if (!potBlockEntity.isHeated(level, pos)) {
            potBlockEntity.clearCookingTime();
            return;
        }
        if (potMatchRecipe.isPresent() && potBlockEntity.canCookRecipe((AbstractPotRecipe)potMatchRecipe.get().value(), wrapper)) {
            if (!((Boolean)CustomizedConfig.RECIPE_COOKING.get()).booleanValue()) {
                return;
            }
            potBlockEntity.cookRecipe(potMatchRecipe.get(), pos, state);
        } else {
            if (!((Boolean)CustomizedConfig.CUSTOM_COOKING.get()).booleanValue()) {
                return;
            }
            potBlockEntity.cookCustomized(level, pos, state);
        }
    }

    public static void animationTick(Level level, BlockPos pos, BlockState state, AbstractPotBlockEntity potBlockEntity) {
        if (potBlockEntity.isHeated(level, pos)) {
            potBlockEntity.particleTick(level, pos, potBlockEntity);
        }
    }

    public abstract void particleTick(Level var1, BlockPos var2, AbstractPotBlockEntity var3);

    protected Optional<RecipeHolder<? extends AbstractPotRecipe>> getPotMatchRecipe(RecipeWrapper recipeWrapper) {
        return this.hasInput() && this.level != null ? this.potCheck.getRecipeFor((RecipeInput)recipeWrapper, this.level).map(holder -> holder) : Optional.empty();
    }

    protected Optional<RecipeHolder<CampfireCookingRecipe>> getCampfireMatchRecipe(ItemStack stack) {
        return this.hasInput() && this.level != null ? this.campfireCheck.getRecipeFor((RecipeInput)new SingleRecipeInput(stack), this.level) : Optional.empty();
    }

    protected boolean hasInput() {
        return ModItemStackHandlerHelper.hasInput(this.itemStackHandler, this.ingredientInput + this.seasoningInput + 1);
    }

    protected boolean canCooking() {
        if (this.level == null) {
            return false;
        }
        return this.hasInput();
    }

    protected boolean canCookRecipe(AbstractPotRecipe recipe, RecipeWrapper recipeWrapper) {
        if (!this.canCooking()) {
            return false;
        }
        if (this.level == null) {
            return false;
        }
        ItemStack resultStack = recipe.getResultItem((HolderLookup.Provider)this.level.registryAccess());
        if (resultStack.isEmpty()) {
            return false;
        }
        if (!recipe.matches(recipeWrapper, this.level)) {
            return false;
        }
        ItemStack stackInSlot = this.itemStackHandler.getStackInSlot(this.ingredientInput + this.seasoningInput + 1);
        if (stackInSlot.isEmpty()) {
            return true;
        }
        if (!ItemStack.isSameItem((ItemStack)stackInSlot, (ItemStack)resultStack)) {
            return false;
        }
        return stackInSlot.getCount() + resultStack.getCount() <= this.itemStackHandler.getSlotLimit(this.ingredientInput + this.seasoningInput + 1);
    }

    protected void cookRecipe(RecipeHolder<? extends AbstractPotRecipe> holder, BlockPos pos, BlockState state) {
        ++this.cookingTime;
        this.getRecipeCookingCompletionTime(holder);
        this.lidAccelerate(state);
        if (this.cookingTime < this.cookingCompletionTime) {
            return;
        }
        if (this.level == null) {
            return;
        }
        ItemStack resultStack = ((AbstractPotRecipe)holder.value()).getResultItem((HolderLookup.Provider)this.level.registryAccess()).copy();
        ItemStack stackInSlot = this.itemStackHandler.getStackInSlot(this.ingredientInput + this.seasoningInput + 1);
        if (stackInSlot.isEmpty()) {
            this.itemStackHandler.setStackInSlot(this.ingredientInput + this.seasoningInput + 1, resultStack);
        } else if (ItemStack.isSameItem((ItemStack)stackInSlot, (ItemStack)resultStack)) {
            stackInSlot.grow(resultStack.getCount());
        }
        for (int i = 0; i < this.ingredientInput + this.seasoningInput + 1; ++i) {
            ItemStack slotStack = this.itemStackHandler.getStackInSlot(i);
            if (slotStack.hasCraftingRemainingItem()) {
                AbstractPotBlockEntity.spawnRemainderItem(slotStack.getCraftingRemainingItem(), this.getBlockState(), this.worldPosition, this.level);
            }
            if (slotStack.isEmpty()) continue;
            slotStack.shrink(1);
        }
        this.clearCookingTime();
        this.itemStackHandlerChanged();
    }

    protected void cookCustomized(Level level, BlockPos pos, BlockState state) {
        for (int i = 0; i < this.ingredientInput; ++i) {
            ItemStack stackInSlot = this.itemStackHandler.getStackInSlot(i);
            Optional<RecipeHolder<CampfireCookingRecipe>> recipe = this.getCampfireMatchRecipe(stackInSlot);
            if (recipe.isEmpty()) continue;
            ++this.cookingTime;
            this.getCustomizedCookingCompletionTime();
            this.lidAccelerate(state);
            if (this.cookingTime < this.cookingCompletionTime) {
                return;
            }
            ItemStack resultStack = ((CampfireCookingRecipe)recipe.get().value()).assemble(new SingleRecipeInput(stackInSlot), (HolderLookup.Provider)level.registryAccess()).copy();
            resultStack.setCount(stackInSlot.getCount());
            this.itemStackHandler.setStackInSlot(i, resultStack);
        }
        this.clearCookingTime();
        this.itemStackHandlerChanged();
    }

    public void takeOutItem(Level level, BlockState state, BlockPos pos) {
        Direction direction = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        double x = (double)pos.getX() + 0.5 + (double)direction.getStepX() * 0.25;
        double y = (double)pos.getY() + 0.7;
        double z = (double)pos.getZ() + 0.5 + (double)direction.getStepZ() * 0.25;
        for (int i = 0; i < this.ingredientInput + this.seasoningInput + 1; ++i) {
            ItemStack stackInSlot = this.getItemStackHandler().getStackInSlot(i);
            if (stackInSlot.isEmpty()) continue;
            ItemEntity itemEntity = new ItemEntity(level, x, y, z, stackInSlot.copy());
            itemEntity.setDeltaMovement((double)((float)direction.getStepX() * -0.1f), (double)0.3f, (double)((float)direction.getStepZ() * -0.1f));
            level.addFreshEntity((Entity)itemEntity);
            stackInSlot.copyAndClear();
        }
        this.itemStackHandlerChanged();
    }

    public void insertItem(ItemStack itemStackInHand) {
        ModItemStackHandlerHelper.insertItem(itemStackInHand, this.itemStackHandler, this.ingredientInput, this.seasoningInput, 1);
        this.itemStackHandlerChanged();
    }

    public void getCustomizedCookingCompletionTime() {
        int time = 100;
        for (int i = 0; i < this.ingredientInput; ++i) {
            time += this.itemStackHandler.getStackInSlot(i).getCount() * 20;
        }
        this.cookingCompletionTime = time;
    }

    public void getRecipeCookingCompletionTime(RecipeHolder<? extends AbstractPotRecipe> holder) {
        this.cookingCompletionTime = ((AbstractPotRecipe)holder.value()).getCookingTime();
    }

    protected static void spawnRemainderItem(ItemStack remainderStack, BlockState state, BlockPos pos, Level level) {
        Direction direction = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        double x = (double)pos.getX() + 0.5 + (double)direction.getStepX() * 0.25;
        double y = (double)pos.getY() + 0.7;
        double z = (double)pos.getZ() + 0.5 + (double)direction.getStepZ() * 0.25;
        if (level != null) {
            ItemEntity entity = new ItemEntity(level, x, y, z, remainderStack);
            entity.setDeltaMovement((double)((float)direction.getStepX() * 0.1f), (double)0.3f, (double)((float)direction.getStepZ() * 0.1f));
            level.addFreshEntity((Entity)entity);
        }
    }

    public boolean isHeated() {
        if (this.level == null) {
            return false;
        }
        return this.isHeated(this.level, this.worldPosition);
    }

    protected boolean isHeated(Level level, BlockPos pos) {
        BlockState stateBelow = level.getBlockState(pos.below());
        if (!stateBelow.is(ModTag.HEAT_SOURCE)) {
            return false;
        }
        if (stateBelow.hasProperty((Property)BlockStateProperties.LIT)) {
            return (Boolean)stateBelow.getValue((Property)BlockStateProperties.LIT);
        }
        return true;
    }

    protected void clearCookingTime() {
        if (this.cookingTime != 0) {
            this.cookingTime = 0;
        }
    }

    public void stirFryAccelerate(ItemStack itemStackInHand, LivingEntity entity, InteractionHand hand) {
        if (!itemStackInHand.is(ModTag.SPATULA) || this.cookingTime == 0) {
            return;
        }
        this.cookingTime += 10;
        itemStackInHand.hurtAndBreak(1, entity, LivingEntity.getSlotForHand((InteractionHand)hand));
    }

    public void lidAccelerate(BlockState state) {
        if (((PotState)((Object)state.getValue(AbstractPotBlock.LID))).equals((Object)PotState.WITH_LID)) {
            ++this.cookingTime;
        }
    }

    public List<ItemStack> getItemStackListInPot(boolean includeOutput, boolean includeSeasoningAndSpice) {
        if (includeOutput) {
            if (includeSeasoningAndSpice) {
                return ModItemStackHandlerHelper.getItemStackListInSlot(this.itemStackHandler, 0, this.allSlot);
            }
            List<ItemStack> stackList = ModItemStackHandlerHelper.getItemStackListInSlot(this.itemStackHandler, 0, this.ingredientInput);
            stackList.addAll(ModItemStackHandlerHelper.getItemStackListInSlot(this.itemStackHandler, this.ingredientInput + this.seasoningInput + 1, this.allSlot));
            return stackList;
        }
        if (includeSeasoningAndSpice) {
            return ModItemStackHandlerHelper.getItemStackListInSlot(this.itemStackHandler, 0, this.ingredientInput + this.seasoningInput + 1);
        }
        return ModItemStackHandlerHelper.getItemStackListInSlot(this.itemStackHandler, 0, this.ingredientInput);
    }

    public void getOutputInPot(ItemStack itemStackInHand, Player player) {
        ModItemStackHandlerHelper.getOutputItem(itemStackInHand, player, this.itemStackHandler, this.ingredientInput + this.seasoningInput + 1);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ModAdvancementRegistry.GET_FAMOUS_DISH.get().trigger(serverPlayer);
        }
        this.itemStackHandlerChanged();
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void loadAdditional(@NotNull CompoundTag compound, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(compound, registries);
        this.itemStackHandler.deserializeNBT(registries, compound.getCompound("ItemStackHandler"));
        this.cookingTime = compound.getInt("CookingTime");
        this.cookingCompletionTime = compound.getInt("CookingCompletionTime");
    }

    public void saveAdditional(@NotNull CompoundTag compound, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(compound, registries);
        compound.putInt("CookingTime", this.cookingTime);
        compound.putInt("CookingCompletionTime", this.cookingCompletionTime);
        compound.put("ItemStackHandler", (Tag)this.itemStackHandler.serializeNBT(registries));
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        super.saveAdditional(tag, registries);
        tag.put("ItemStackHandler", (Tag)this.itemStackHandler.serializeNBT(registries));
        return tag;
    }

    public int getIngredientInput() {
        return this.ingredientInput;
    }

    public int getSeasoningInput() {
        return this.seasoningInput;
    }

    public ItemStackHandler getItemStackHandler() {
        return this.itemStackHandler;
    }

    public IItemHandler getInputHandler() {
        return this.inputHandler;
    }

    public IItemHandler getOutputHandler() {
        return this.outputHandler;
    }

    public RecipeManager.CachedCheck<RecipeWrapper, ? extends AbstractPotRecipe> getPotCheck() {
        return this.potCheck;
    }

    public RecipeManager.CachedCheck<SingleRecipeInput, CampfireCookingRecipe> getCampfireCheck() {
        return this.campfireCheck;
    }
}

