/*
 * Decompiled with CFR 0.152.
 */
package mangopill.customized.common.block.entity;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import mangopill.customized.common.block.BrewingBarrelBlock;
import mangopill.customized.common.block.entity.AbstractPotBlockEntity;
import mangopill.customized.common.block.handler.BrewingBarrelItemHandler;
import mangopill.customized.common.recipe.BrewingBarrelRecipe;
import mangopill.customized.common.registry.ModAdvancementRegistry;
import mangopill.customized.common.registry.ModBlockEntityTypeRegistry;
import mangopill.customized.common.registry.ModRecipeRegistry;
import mangopill.customized.common.util.CreateItemStackHandler;
import mangopill.customized.common.util.ModItemStackHandlerHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.RecipeWrapper;
import org.jetbrains.annotations.NotNull;

public class BrewingBarrelBlockEntity
extends BlockEntity
implements CreateItemStackHandler {
    private final int inputSlot;
    private final int outputSlot;
    private final int allSlot;
    private final RecipeManager.CachedCheck<RecipeWrapper, BrewingBarrelRecipe> check;
    private final ItemStackHandler itemStackHandler;
    private final IItemHandler inputHandler;
    private final IItemHandler outputHandler;
    private ItemStack containerItem;
    private int cookingTime;
    private int cookingCompletionTime;

    public BrewingBarrelBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntityTypeRegistry.BREWING_BARREL.get(), pos, blockState);
        this.inputSlot = 4;
        this.outputSlot = 1;
        this.allSlot = this.inputSlot + this.outputSlot;
        this.itemStackHandler = this.createItemStackHandler(this.allSlot);
        this.inputHandler = new BrewingBarrelItemHandler((IItemHandler)this.itemStackHandler, Direction.UP, this.inputSlot);
        this.outputHandler = new BrewingBarrelItemHandler((IItemHandler)this.itemStackHandler, Direction.DOWN, this.inputSlot);
        this.containerItem = ItemStack.EMPTY;
        this.check = RecipeManager.createCheck(ModRecipeRegistry.BREWING_BARREL.get());
    }

    public static void cookingTick(Level level, BlockPos pos, BlockState state, BrewingBarrelBlockEntity barrelBlockEntity) {
        RecipeWrapper wrapper = new RecipeWrapper((IItemHandler)barrelBlockEntity.itemStackHandler);
        Optional<RecipeHolder<BrewingBarrelRecipe>> barrelMatchRecipe = barrelBlockEntity.getBrewingBarrelMatchRecipe(wrapper);
        if (barrelMatchRecipe.isPresent() && barrelBlockEntity.canCookRecipe((BrewingBarrelRecipe)barrelMatchRecipe.get().value(), wrapper)) {
            barrelBlockEntity.cookRecipe(level, barrelMatchRecipe.get(), pos, state, barrelBlockEntity);
        } else {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)BrewingBarrelBlock.PROGRESS, (Comparable)Integer.valueOf(0)));
        }
    }

    protected void cookRecipe(Level level, RecipeHolder<BrewingBarrelRecipe> holder, BlockPos pos, BlockState state, BrewingBarrelBlockEntity barrelBlockEntity) {
        ++this.cookingTime;
        this.getRecipeCookingCompletionTime(holder);
        if (this.level == null) {
            return;
        }
        if (this.cookingTime < this.cookingCompletionTime) {
            return;
        }
        Block block = level.getBlockState(pos).getBlock();
        if (block instanceof BrewingBarrelBlock) {
            if ((Integer)state.getValue((Property)BrewingBarrelBlock.PROGRESS) < 12) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)BrewingBarrelBlock.PROGRESS, (Comparable)Integer.valueOf((Integer)state.getValue((Property)BrewingBarrelBlock.PROGRESS) + 1)));
                barrelBlockEntity.clearCookingTime();
                return;
            }
            ItemStack resultStack = ((BrewingBarrelRecipe)holder.value()).getResultItem((HolderLookup.Provider)this.level.registryAccess()).copy();
            ItemStack stackInSlot = this.itemStackHandler.getStackInSlot(this.inputSlot);
            if (stackInSlot.isEmpty()) {
                this.itemStackHandler.setStackInSlot(this.inputSlot, resultStack);
            } else if (ItemStack.isSameItemSameComponents((ItemStack)stackInSlot, (ItemStack)resultStack)) {
                stackInSlot.grow(resultStack.getCount());
            }
            for (int i = 0; i < this.inputSlot; ++i) {
                ItemStack slotStack = this.itemStackHandler.getStackInSlot(i);
                if (slotStack.hasCraftingRemainingItem()) {
                    AbstractPotBlockEntity.spawnRemainderItem(slotStack.getCraftingRemainingItem(), this.getBlockState(), this.worldPosition, level);
                }
                if (slotStack.isEmpty()) continue;
                slotStack.shrink(1);
            }
            this.containerItem = ((BrewingBarrelRecipe)holder.value()).getContainerItem().getItems()[0];
            this.clearCookingTime();
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)BrewingBarrelBlock.PROGRESS, (Comparable)Integer.valueOf(0)));
            this.itemStackHandlerChanged();
        }
    }

    protected boolean canCookRecipe(BrewingBarrelRecipe recipe, RecipeWrapper recipeWrapper) {
        if (!this.canCooking()) {
            return false;
        }
        if (this.level == null) {
            return false;
        }
        ItemStack resultStack = recipe.getResultItem((HolderLookup.Provider)this.level.registryAccess());
        if (resultStack.isEmpty()) {
            return false;
        }
        if (!recipe.matches(recipeWrapper, this.level)) {
            return false;
        }
        ItemStack stackInSlot = this.itemStackHandler.getStackInSlot(this.inputSlot);
        if (stackInSlot.isEmpty()) {
            return true;
        }
        if (!ItemStack.isSameItem((ItemStack)stackInSlot, (ItemStack)resultStack)) {
            return false;
        }
        return stackInSlot.getCount() + resultStack.getCount() <= this.itemStackHandler.getSlotLimit(this.inputSlot);
    }

    protected Optional<RecipeHolder<BrewingBarrelRecipe>> getBrewingBarrelMatchRecipe(RecipeWrapper recipeWrapper) {
        return this.hasInput() && this.level != null ? this.check.getRecipeFor((RecipeInput)recipeWrapper, this.level) : Optional.empty();
    }

    public void interact(ItemStack itemStackInHand, Player player, Level level, BlockPos pos) {
        if (itemStackInHand.isEmpty() && player.isShiftKeyDown()) {
            this.getItemStackListInBrewingBarrel(false).forEach(itemStack -> {
                if (!player.getInventory().add(itemStack)) {
                    player.drop(itemStack, false);
                }
            });
            level.playSound(null, pos, SoundEvents.BARREL_CLOSE, SoundSource.BLOCKS, 0.8f, 1.0f);
            this.itemStackHandlerChanged();
            return;
        }
        if (this.canOutput(itemStackInHand)) {
            ItemStack outputItem = this.getOutputItem();
            if (outputItem == null || outputItem.isEmpty()) {
                return;
            }
            ModItemStackHandlerHelper.getOutputItem(itemStackInHand, player, this.itemStackHandler, this.inputSlot);
            level.playSound(null, pos, SoundEvents.BARREL_CLOSE, SoundSource.BLOCKS, 0.8f, 1.0f);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ModAdvancementRegistry.USE_BREWING_BARREL.get().trigger(serverPlayer);
            }
            this.itemStackHandlerChanged();
        } else {
            this.insertItem(itemStackInHand);
            level.playSound(null, pos, SoundEvents.BARREL_OPEN, SoundSource.BLOCKS, 0.8f, 1.0f);
            this.itemStackHandlerChanged();
        }
    }

    public void insertItem(ItemStack itemStackInHand) {
        ModItemStackHandlerHelper.fillInItem(this.itemStackHandler, itemStackInHand, 0, this.inputSlot);
        this.itemStackHandlerChanged();
    }

    @Nullable
    public ItemStack getOutputItem() {
        return this.itemStackHandler.getStackInSlot(this.inputSlot);
    }

    public boolean canOutput(ItemStack itemStackInHand) {
        return !this.containerItem.isEmpty() && ItemStack.isSameItem((ItemStack)this.containerItem, (ItemStack)itemStackInHand);
    }

    protected boolean hasInput() {
        return ModItemStackHandlerHelper.hasInput(this.itemStackHandler, this.inputSlot);
    }

    public List<ItemStack> getItemStackListInBrewingBarrel(boolean includeOutput) {
        if (includeOutput) {
            return ModItemStackHandlerHelper.getItemStackListInSlot(this.itemStackHandler, 0, this.allSlot);
        }
        return ModItemStackHandlerHelper.getItemStackListInSlot(this.itemStackHandler, 0, this.inputSlot);
    }

    protected boolean canCooking() {
        if (this.level == null) {
            return false;
        }
        return this.hasInput();
    }

    protected void clearCookingTime() {
        if (this.cookingTime >= this.cookingCompletionTime) {
            this.cookingTime = 0;
        }
    }

    public void getRecipeCookingCompletionTime(RecipeHolder<BrewingBarrelRecipe> holder) {
        this.cookingCompletionTime = ((BrewingBarrelRecipe)holder.value()).getCookingTime();
    }

    @Override
    public void itemStackHandlerChanged() {
        super.setChanged();
        if (this.level != null) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
        }
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void loadAdditional(@NotNull CompoundTag compound, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(compound, registries);
        this.itemStackHandler.deserializeNBT(registries, compound.getCompound("ItemStackHandler"));
        this.containerItem = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)compound.getCompound("Container"));
        this.cookingTime = compound.getInt("CookingTime");
        this.cookingCompletionTime = compound.getInt("CookingCompletionTime");
    }

    public void saveAdditional(@NotNull CompoundTag compound, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(compound, registries);
        compound.putInt("CookingTime", this.cookingTime);
        compound.putInt("CookingCompletionTime", this.cookingCompletionTime);
        compound.put("ItemStackHandler", (Tag)this.itemStackHandler.serializeNBT(registries));
        compound.put("Container", this.containerItem.saveOptional(registries));
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        super.saveAdditional(tag, registries);
        tag.put("ItemStackHandler", (Tag)this.itemStackHandler.serializeNBT(registries));
        tag.put("Container", this.containerItem.saveOptional(registries));
        return tag;
    }

    public int getInputSlot() {
        return this.inputSlot;
    }

    public int getOutputSlot() {
        return this.outputSlot;
    }

    public RecipeManager.CachedCheck<RecipeWrapper, BrewingBarrelRecipe> getCheck() {
        return this.check;
    }

    public ItemStackHandler getItemStackHandler() {
        return this.itemStackHandler;
    }

    public IItemHandler getInputHandler() {
        return this.inputHandler;
    }

    public IItemHandler getOutputHandler() {
        return this.outputHandler;
    }

    public int getCookingTime() {
        return this.cookingTime;
    }

    public int getCookingCompletionTime() {
        return this.cookingCompletionTime;
    }

    public ItemStack getContainerItem() {
        return this.containerItem;
    }
}

