/*
 * Decompiled with CFR 0.152.
 */
package mangopill.customized.common.block.handler;

import mangopill.customized.common.block.fluid.ModFluidContent;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public abstract class ModIFluidHandler<T extends Comparable<T>, V extends T>
implements IFluidHandler {
    private final Level level;
    private final BlockPos pos;

    public ModIFluidHandler(Level level, BlockPos pos) {
        this.level = level;
        this.pos = pos;
    }

    protected abstract ModFluidContent<T, V> getContent();

    protected abstract ModFluidContent<T, V> getContentForFill();

    protected abstract boolean canInput();

    protected abstract boolean canOutput();

    protected void updateDriveState(IFluidHandler.FluidAction action, ModFluidContent<T, V> contents) {
        if (!action.execute()) {
            return;
        }
        if (this.canInput()) {
            BlockState blockState = this.getLevel().getBlockState(this.getPos());
            this.getLevel().setBlockAndUpdate(this.getPos(), (BlockState)blockState.setValue(contents.getProperty(), contents.getValue()));
        }
    }

    protected void updateWithoutDriveState(IFluidHandler.FluidAction action, ModFluidContent<T, V> contents) {
        if (!action.execute()) {
            return;
        }
        if (this.canOutput()) {
            BlockState blockState = this.getLevel().getBlockState(this.getPos());
            this.getLevel().setBlockAndUpdate(this.getPos(), (BlockState)blockState.setValue(contents.getProperty(), contents.getValue()));
        }
    }

    public int getTanks() {
        return 1;
    }

    @NotNull
    public FluidStack getFluidInTank(int i) {
        ModFluidContent<T, V> contents = this.getContent();
        return new FluidStack(contents.getFluid(), contents.getTotalAmount());
    }

    public int getTankCapacity(int i) {
        ModFluidContent<T, V> contents = this.getContent();
        return contents.getTotalAmount();
    }

    public boolean isFluidValid(int i, @NotNull FluidStack fluidStack) {
        return true;
    }

    public int fill(@NotNull FluidStack fluidStack, @NotNull IFluidHandler.FluidAction fluidAction) {
        if (fluidStack.isEmpty()) {
            return 0;
        }
        ModFluidContent<T, V> contents = this.getContentForFill();
        if (contents.getFluid() != Fluids.EMPTY && !fluidStack.is(contents.getFluid())) {
            return 0;
        }
        int amount = fluidStack.getAmount();
        if (this.canInput()) {
            if (amount >= contents.getTotalAmount()) {
                this.updateDriveState(fluidAction, contents);
                return contents.getTotalAmount();
            }
            return 0;
        }
        return 0;
    }

    @NotNull
    public FluidStack drain(@NotNull FluidStack fluidStack, @NotNull IFluidHandler.FluidAction fluidAction) {
        if (fluidStack.isEmpty()) {
            return FluidStack.EMPTY;
        }
        return fluidStack.is(this.getContent().getFluid()) && fluidStack.getComponents().isEmpty() && this.canOutput() && fluidStack.getAmount() >= this.getContent().getTotalAmount() ? this.drain(fluidAction) : FluidStack.EMPTY;
    }

    @NotNull
    public FluidStack drain(int maxDrain, @NotNull IFluidHandler.FluidAction fluidAction) {
        return maxDrain <= 0 ? FluidStack.EMPTY : this.drain(fluidAction);
    }

    protected FluidStack drain(IFluidHandler.FluidAction fluidAction) {
        ModFluidContent<T, V> content = this.getContent();
        this.updateWithoutDriveState(fluidAction, content);
        return new FluidStack(content.getFluid(), content.getTotalAmount());
    }

    public Level getLevel() {
        return this.level;
    }

    public BlockPos getPos() {
        return this.pos;
    }
}

