/*
 * Decompiled with CFR 0.152.
 */
package mangopill.customized.common.block.handler;

import javax.annotation.Nullable;
import mangopill.customized.common.tag.ModTag;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class PotItemHandler
implements IItemHandler {
    private final int ingredientInput;
    private final int seasoningInput;
    private static final int SPICE_INPUT = 1;
    private final IItemHandler itemHandler;
    private final Direction side;

    public PotItemHandler(IItemHandler itemHandler, @Nullable Direction side, int ingredientCount, int seasoningCount) {
        this.itemHandler = itemHandler;
        this.ingredientInput = ingredientCount;
        this.seasoningInput = seasoningCount;
        this.side = side;
    }

    public int getSlots() {
        return this.itemHandler.getSlots();
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        return this.itemHandler.getStackInSlot(slot);
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        if (this.side == null || this.side.equals((Object)Direction.UP)) {
            return slot < this.ingredientInput ? this.itemHandler.insertItem(slot, stack, simulate) : stack;
        }
        if (slot < this.seasoningInput + this.ingredientInput && slot >= this.ingredientInput) {
            return stack.is(ModTag.SEASONING) ? this.itemHandler.insertItem(slot, stack, simulate) : stack;
        }
        if (slot == this.seasoningInput + this.ingredientInput) {
            return stack.is(ModTag.FAMOUS_SPICE) ? this.itemHandler.insertItem(slot, stack, simulate) : stack;
        }
        return stack;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.side == null || this.side.equals((Object)Direction.UP)) {
            return slot < this.seasoningInput + this.ingredientInput + 1 ? this.itemHandler.extractItem(slot, amount, simulate) : ItemStack.EMPTY;
        }
        return slot == this.seasoningInput + this.ingredientInput + 1 ? this.itemHandler.extractItem(slot, amount, simulate) : ItemStack.EMPTY;
    }

    public int getSlotLimit(int slot) {
        return this.itemHandler.getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return this.itemHandler.isItemValid(slot, stack);
    }
}

