/*
 * Decompiled with CFR 0.152.
 */
package mangopill.customized.common.block.strategy.base;

import com.google.common.collect.Maps;
import java.util.Map;
import mangopill.customized.common.block.entity.AbstractPotBlockEntity;
import mangopill.customized.common.block.strategy.base.PotInteractionStrategy;
import mangopill.customized.common.block.strategy.base.PotStrategyRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public class PotStrategyHandler {
    private static volatile PotStrategyHandler registry;
    private final Map<String, PotInteractionStrategy[]> map = Maps.newHashMap();
    private int count = 0;

    private PotStrategyHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PotStrategyHandler getInstance() {
        Class<PotStrategyHandler> clazz = PotStrategyHandler.class;
        synchronized (PotStrategyHandler.class) {
            if (registry == null) {
                registry = new PotStrategyHandler();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return registry;
        }
    }

    public void registry(@NotNull String potName, PotInteractionStrategy ... strategy) {
        if (this.map.containsKey(potName)) {
            return;
        }
        this.map.put(potName, strategy);
        ++this.count;
    }

    public ItemInteractionResult useByRegistry(String potName, ItemStack itemStackInHand, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (level.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof AbstractPotBlockEntity) {
            AbstractPotBlockEntity potBlockEntity = (AbstractPotBlockEntity)blockEntity;
            if (this.count == 0) {
                PotStrategyRegistry.onPotRegistry();
            }
            for (PotInteractionStrategy strategy : this.map.get(potName)) {
                if (strategy.interact(itemStackInHand, state, level, pos, player, hand, result)) break;
            }
            potBlockEntity.itemStackHandlerChanged();
        }
        return ItemInteractionResult.SUCCESS;
    }

    public Map<String, PotInteractionStrategy[]> getMap() {
        return this.map;
    }

    public int getCount() {
        return this.count;
    }
}

