/*
 * Decompiled with CFR 0.152.
 */
package mangopill.customized.common.block.strategy.pot;

import mangopill.customized.common.block.AbstractPotBlock;
import mangopill.customized.common.block.entity.AbstractPotBlockEntity;
import mangopill.customized.common.block.state.PotState;
import mangopill.customized.common.block.strategy.base.PotInteractionStrategy;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class InsertAndTakeOutItemStrategy
implements PotInteractionStrategy {
    @Override
    public boolean interact(ItemStack itemStackInHand, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof AbstractPotBlockEntity) {
            AbstractPotBlockEntity potBlockEntity = (AbstractPotBlockEntity)blockEntity;
            if (((PotState)((Object)state.getValue(AbstractPotBlock.LID))).equals((Object)PotState.WITH_LID)) {
                return false;
            }
            if (itemStackInHand.isEmpty()) {
                if (player.isShiftKeyDown()) {
                    this.takeOut(state, level, pos, potBlockEntity);
                    return true;
                }
            } else {
                this.insert(itemStackInHand, level, pos, potBlockEntity);
                return true;
            }
        }
        return false;
    }

    private void insert(ItemStack itemStackInHand, Level level, BlockPos pos, AbstractPotBlockEntity potBlockEntity) {
        potBlockEntity.insertItem(itemStackInHand);
        level.playSound(null, pos, SoundEvents.DECORATED_POT_INSERT, SoundSource.BLOCKS, 0.8f, 1.0f);
    }

    private void takeOut(BlockState state, Level level, BlockPos pos, AbstractPotBlockEntity potBlockEntity) {
        potBlockEntity.takeOutItem(level, state, pos);
        level.playSound(null, pos, SoundEvents.DECORATED_POT_INSERT_FAIL, SoundSource.BLOCKS, 0.8f, 1.0f);
    }
}

