/*
 * Decompiled with CFR 0.152.
 */
package mangopill.customized.common.block.strategy.pot;

import mangopill.customized.common.block.AbstractPotBlock;
import mangopill.customized.common.block.state.PotState;
import mangopill.customized.common.block.strategy.base.PotInteractionStrategy;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class LidStrategy
implements PotInteractionStrategy {
    private final ItemStack lid;
    private final boolean canInputDrive;

    public LidStrategy(ItemStack lid, boolean canInputDrive) {
        this.lid = lid;
        this.canInputDrive = canInputDrive;
    }

    @Override
    public boolean interact(ItemStack itemStackInHand, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (itemStackInHand.isEmpty() && ((PotState)((Object)state.getValue(AbstractPotBlock.LID))).equals((Object)PotState.WITH_LID)) {
            if (this.canInputDrive) {
                this.removeTheLidDrive(state, level, pos, player);
            } else {
                this.removeTheLid(state, level, pos, player);
            }
            return true;
        }
        if (itemStackInHand.is(this.lid.getItem()) && !((PotState)((Object)state.getValue(AbstractPotBlock.LID))).equals((Object)PotState.WITH_LID)) {
            if (this.canInputDrive) {
                if (((PotState)((Object)state.getValue(AbstractPotBlock.LID))).equals((Object)PotState.WITH_DRIVE)) {
                    this.addLid(itemStackInHand, state, level, pos, player);
                    return true;
                }
            } else {
                this.addLid(itemStackInHand, state, level, pos, player);
                return true;
            }
        }
        return false;
    }

    private void addLid(ItemStack itemStackInHand, BlockState state, Level level, BlockPos pos, Player player) {
        if (!player.isCreative()) {
            itemStackInHand.shrink(1);
        }
        level.setBlockAndUpdate(pos, (BlockState)state.setValue(AbstractPotBlock.LID, (Comparable)((Object)PotState.WITH_LID)));
        level.playSound(null, pos, SoundEvents.DECORATED_POT_PLACE, SoundSource.BLOCKS, 0.8f, 1.0f);
    }

    private void removeTheLid(BlockState state, Level level, BlockPos pos, Player player) {
        level.setBlockAndUpdate(pos, (BlockState)state.setValue(AbstractPotBlock.LID, (Comparable)((Object)PotState.WITHOUT_LID)));
        if (!player.getInventory().add(this.lid.copy())) {
            player.drop(this.lid.copy(), false);
        }
        level.playSound(null, pos, SoundEvents.DECORATED_POT_HIT, SoundSource.BLOCKS, 0.8f, 1.0f);
    }

    private void removeTheLidDrive(BlockState state, Level level, BlockPos pos, Player player) {
        level.setBlockAndUpdate(pos, (BlockState)state.setValue(AbstractPotBlock.LID, (Comparable)((Object)PotState.WITH_DRIVE)));
        if (!player.getInventory().add(this.lid.copy())) {
            player.drop(this.lid.copy(), false);
        }
        level.playSound(null, pos, SoundEvents.DECORATED_POT_HIT, SoundSource.BLOCKS, 0.8f, 1.0f);
    }

    public ItemStack getLid() {
        return this.lid;
    }

    public boolean isCanInputDrive() {
        return this.canInputDrive;
    }
}

