/*
 * Decompiled with CFR 0.152.
 */
package mangopill.customized.common.block.strategy.pot;

import mangopill.customized.common.block.AbstractPotBlock;
import mangopill.customized.common.block.entity.AbstractPotBlockEntity;
import mangopill.customized.common.block.state.PotState;
import mangopill.customized.common.block.strategy.base.PotInteractionStrategy;
import mangopill.customized.common.tag.ModTag;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class StirFryStrategy
implements PotInteractionStrategy {
    @Override
    public boolean interact(ItemStack itemStackInHand, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof AbstractPotBlockEntity) {
            AbstractPotBlockEntity potBlockEntity = (AbstractPotBlockEntity)blockEntity;
            if (!this.canStirFry(itemStackInHand, state)) {
                return false;
            }
            this.stirFry(itemStackInHand, level, pos, player, hand, potBlockEntity);
            return true;
        }
        return false;
    }

    private boolean canStirFry(ItemStack itemStackInHand, BlockState state) {
        return !itemStackInHand.isEmpty() && !((PotState)((Object)state.getValue(AbstractPotBlock.LID))).equals((Object)PotState.WITH_LID) && itemStackInHand.is(ModTag.SPATULA);
    }

    private void stirFry(ItemStack itemStackInHand, Level level, BlockPos pos, Player player, InteractionHand hand, AbstractPotBlockEntity potBlockEntity) {
        potBlockEntity.stirFryAccelerate(itemStackInHand, (LivingEntity)player, hand);
        level.playSound(null, pos, SoundEvents.METAL_HIT, SoundSource.BLOCKS, 1.0f, 1.0f);
    }
}

