/*
 * Decompiled with CFR 0.152.
 */
package mangopill.customized.common.effect.combination;

import java.util.List;
import java.util.Set;
import mangopill.customized.common.effect.CombinationMobEffect;
import mangopill.customized.common.effect.ModMobEffect;
import mangopill.customized.common.util.category.NutrientCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import org.jetbrains.annotations.NotNull;

public class RobustEffect
extends ModMobEffect
implements CombinationMobEffect {
    public RobustEffect(int color) {
        super(color);
        super.addAttributeModifier(Attributes.MAX_HEALTH, ResourceLocation.withDefaultNamespace((String)"effect.robust_health_boost"), 5.0, AttributeModifier.Operation.ADD_VALUE);
        super.addAttributeModifier(Attributes.ATTACK_DAMAGE, ResourceLocation.withDefaultNamespace((String)"effect.robust_strength"), 4.0, AttributeModifier.Operation.ADD_VALUE);
    }

    public void onEffectStarted(@NotNull LivingEntity livingEntity, int amplifier) {
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            player.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 500, amplifier));
        }
    }

    @Override
    public List<Set<NutrientCategory>> getCategorySet() {
        return List.of(Set.of(NutrientCategory.PROTEIN, NutrientCategory.LIPID, NutrientCategory.CARBOHYDRATE));
    }
}

