/*
 * Decompiled with CFR 0.152.
 */
package mangopill.customized.common.item;

import java.util.List;
import javax.annotation.Nullable;
import mangopill.customized.common.FoodValue;
import mangopill.customized.common.block.AbstractPlateBlock;
import mangopill.customized.common.block.AbstractPotBlock;
import mangopill.customized.common.block.entity.AbstractPlateBlockEntity;
import mangopill.customized.common.block.entity.AbstractPotBlockEntity;
import mangopill.customized.common.block.state.PlateState;
import mangopill.customized.common.block.state.PotState;
import mangopill.customized.common.registry.ModAdvancementRegistry;
import mangopill.customized.common.util.ModItemStackHandlerHelper;
import mangopill.customized.common.util.PlateComponentUtil;
import mangopill.customized.common.util.PropertyValueUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.StringUtil;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractPlateItem
extends BlockItem {
    private final int ingredientInput;
    private final int seasoningInput;
    private final boolean canInputDrive;

    public AbstractPlateItem(Block block, Item.Properties properties, int ingredientInput, int seasoningInput, boolean canInputDrive) {
        super(block, properties);
        this.ingredientInput = ingredientInput;
        this.seasoningInput = seasoningInput;
        this.canInputDrive = canInputDrive;
    }

    public void appendHoverText(@NotNull ItemStack stack, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        tooltipComponents.add((Component)Component.translatable((String)"item_text.customized.consumption_count_total", (Object[])new Object[]{PlateComponentUtil.getConsumptionCountTotal(stack)}).withStyle(ChatFormatting.GRAY));
        tooltipComponents.add((Component)Component.translatable((String)"item_text.customized.consumption_count", (Object[])new Object[]{PlateComponentUtil.getConsumptionCount(stack)}).withStyle(ChatFormatting.GRAY));
        this.addItemStackTooltip(stack, tooltipComponents);
        if (PlateComponentUtil.getFoodProperty(stack).equals((Object)FoodValue.INEDIBLE)) {
            tooltipComponents.add((Component)Component.translatable((String)"item_text.customized.inedible").withStyle(ChatFormatting.DARK_RED));
        }
        this.addEffectTooltip(stack, context, tooltipComponents);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand usedHand) {
        ItemStack itemstack = player.getItemInHand(usedHand);
        if (level.isClientSide) {
            return InteractionResultHolder.success((Object)itemstack);
        }
        if (PlateComponentUtil.getConsumptionCount(itemstack) <= 0) {
            return InteractionResultHolder.pass((Object)itemstack);
        }
        return super.use(level, player, usedHand);
    }

    @NotNull
    public ItemStack finishUsingItem(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity livingEntity) {
        if (level.isClientSide) {
            return stack;
        }
        int consumptionCount = PlateComponentUtil.getConsumptionCount(stack);
        int consumptionCountTotal = PlateComponentUtil.getConsumptionCountTotal(stack);
        ItemStackHandler newItemStackHandler = this.copyItemStackHandlerByComponent(stack);
        FoodProperties properties = PlateComponentUtil.getFoodProperty(stack);
        AbstractPlateItem.plateAdvancement(livingEntity, properties);
        if (consumptionCount >= 1) {
            level.playSound(null, livingEntity.getX(), livingEntity.getY(), livingEntity.getZ(), livingEntity.getEatingSound(stack), SoundSource.NEUTRAL, 1.0f, 1.0f + (level.random.nextFloat() - level.random.nextFloat()) * 0.4f);
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)livingEntity;
                player.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
                player.getFoodData().eat(properties);
            }
            AbstractPlateBlockEntity.addEffect(livingEntity, properties);
            if (consumptionCount > 1) {
                ModItemStackHandlerHelper.reduceItemStackCountByDivision(newItemStackHandler, consumptionCountTotal);
            } else {
                ModItemStackHandlerHelper.clearAllSlot(newItemStackHandler);
                PlateComponentUtil.setFoodProperty(stack, FoodValue.NULL);
                PlateComponentUtil.setConsumptionCountTotal(stack, 0);
            }
            PlateComponentUtil.setItemStackHandler(stack, newItemStackHandler);
            PlateComponentUtil.setConsumptionCount(stack, --consumptionCount);
            livingEntity.gameEvent((Holder)GameEvent.EAT);
        }
        return stack;
    }

    public static void plateAdvancement(@NotNull LivingEntity livingEntity, FoodProperties properties) {
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            if (properties.equals((Object)FoodValue.INEDIBLE)) {
                ModAdvancementRegistry.EAT_INEDIBLE_STEW.get().trigger(serverPlayer);
            } else {
                ModAdvancementRegistry.EAT_NORMAL_STEW.get().trigger(serverPlayer);
            }
        }
    }

    public FoodProperties getFoodProperties(@NotNull ItemStack stack, @Nullable LivingEntity entity) {
        return PlateComponentUtil.getFoodProperty(stack);
    }

    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext context) {
        Level level = context.getLevel();
        ItemStack itemInHand = context.getItemInHand();
        Player player = context.getPlayer();
        BlockPos pos = context.getClickedPos();
        BlockEntity blockEntity = level.getBlockEntity(pos);
        AbstractPotBlockEntity potEntity = this.getPotEntity(level, pos);
        BlockState state = level.getBlockState(pos);
        if (level.isClientSide || player == null) {
            return InteractionResult.SUCCESS;
        }
        if (blockEntity != null && blockEntity.equals(potEntity) && player.isShiftKeyDown()) {
            if (!((PotState)((Object)state.getValue(AbstractPotBlock.LID))).equals((Object)PotState.WITH_DRIVE) || !potEntity.isHeated()) {
                return InteractionResult.PASS;
            }
            return this.getInteractionResult(this.getPotEntity(level, pos), itemInHand, level, player);
        }
        return player.isShiftKeyDown() ? super.useOn(context) : this.use(level, player, context.getHand()).getResult();
    }

    @NotNull
    public InteractionResult place(@NotNull BlockPlaceContext context) {
        AbstractPlateBlockEntity plateBlockEntity;
        super.place(context);
        BlockPos pos = context.getClickedPos();
        BlockState state = context.getLevel().getBlockState(pos);
        Level level = context.getLevel();
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (this.canInputDrive && blockEntity instanceof AbstractPlateBlockEntity && (plateBlockEntity = (AbstractPlateBlockEntity)blockEntity).hasInput()) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue(AbstractPlateBlock.DRIVE, (Comparable)((Object)PlateState.WITH_DRIVE)));
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public boolean isBarVisible(@NotNull ItemStack stack) {
        return PlateComponentUtil.getConsumptionCountTotal(stack) > 0;
    }

    public int getBarWidth(@NotNull ItemStack stack) {
        int consumptionCount = PlateComponentUtil.getConsumptionCount(stack);
        int consumptionCountTotal = PlateComponentUtil.getConsumptionCountTotal(stack);
        return (int)Math.ceil((double)consumptionCount / (double)consumptionCountTotal * 13.0);
    }

    public int getBarColor(@NotNull ItemStack stack) {
        return 0x5555FF;
    }

    @NotNull
    public Component getName(@NotNull ItemStack stack) {
        List<ItemStack> stackList = this.getItemStackListInPlate(stack, false);
        List<ItemStack> topTwoItems = ModItemStackHandlerHelper.getTopTwoItemsByCount(stackList);
        if (topTwoItems.size() == 1) {
            ItemStack aStack = ModItemStackHandlerHelper.getTopTwoItemsByCount(stackList).getFirst();
            return Component.translatable((String)"").append(aStack.getDisplayName()).append(":").append((Component)Component.translatable((String)(this.getDescriptionId(stack) + "_food")));
        }
        if (topTwoItems.size() == 2) {
            ItemStack aStack = ModItemStackHandlerHelper.getTopTwoItemsByCount(stackList).getFirst();
            ItemStack bStack = ModItemStackHandlerHelper.getTopTwoItemsByCount(stackList).get(1);
            return Component.translatable((String)"").append(aStack.getDisplayName()).append("&").append(bStack.getDisplayName()).append(":").append((Component)Component.translatable((String)(this.getDescriptionId(stack) + "_food")));
        }
        return Component.translatable((String)this.getDescriptionId(stack));
    }

    private InteractionResult getInteractionResult(AbstractPotBlockEntity potBlockEntity, ItemStack itemInHand, Level level, Player player) {
        List<ItemStack> stackList = potBlockEntity.getItemStackListInPot(false, true);
        ItemStackHandler newItemStackHandler = this.copyItemStackHandlerByComponent(itemInHand);
        ModItemStackHandlerHelper.spawnUsingConvertsTo(player, stackList);
        stackList.forEach(itemStack -> this.insertItem((ItemStack)itemStack, newItemStackHandler));
        List<ItemStack> newStackList = ModItemStackHandlerHelper.getItemStackListInSlot(newItemStackHandler, 0, newItemStackHandler.getSlots());
        potBlockEntity.itemStackHandlerChanged();
        PlateComponentUtil.updateAll(itemInHand, newItemStackHandler, PropertyValueUtil.getFoodPropertyByPropertyValue(level, newStackList, true), ModItemStackHandlerHelper.getConsumptionCount(newStackList), ModItemStackHandlerHelper.getConsumptionCount(newStackList));
        return InteractionResult.SUCCESS;
    }

    public void insertItem(ItemStack stack, ItemStackHandler newItemStackHandler) {
        ModItemStackHandlerHelper.insertItem(stack, newItemStackHandler, this.ingredientInput, this.seasoningInput, 1);
    }

    public ItemStackHandler copyItemStackHandlerByComponent(ItemStack stack) {
        ItemStackHandler newItemStackHandler = new ItemStackHandler(PlateComponentUtil.getItemStackHandler(stack).getSlots());
        this.getItemStackListInPlate(stack, true).forEach(itemStack -> this.insertItem((ItemStack)itemStack, newItemStackHandler));
        return newItemStackHandler;
    }

    public boolean hasInput(ItemStack stack) {
        return ModItemStackHandlerHelper.hasInput(PlateComponentUtil.getItemStackHandler(stack), PlateComponentUtil.getItemStackHandler(stack).getSlots());
    }

    public List<ItemStack> getItemStackListInPlate(ItemStack stack, boolean includeSeasoningAndSpice) {
        return includeSeasoningAndSpice ? ModItemStackHandlerHelper.getItemStackListInSlot(PlateComponentUtil.getItemStackHandler(stack), 0, PlateComponentUtil.getItemStackHandler(stack).getSlots()) : ModItemStackHandlerHelper.getItemStackListInSlot(PlateComponentUtil.getItemStackHandler(stack), 0, this.ingredientInput);
    }

    public void addItemStackTooltip(@NotNull ItemStack stack, @NotNull List<Component> tooltipComponents) {
        List<ItemStack> stackList = this.getItemStackListInPlate(stack, true);
        if (!stackList.isEmpty()) {
            stackList.forEach(itemStack -> tooltipComponents.add((Component)Component.translatable((String)"item_text.customized.item_stack", (Object[])new Object[]{itemStack.getCount(), Component.translatable((String)itemStack.getItem().getDescriptionId())}).withStyle(ChatFormatting.GRAY)));
        }
    }

    public void addEffectTooltip(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents) {
        if (!PlateComponentUtil.getFoodProperty(stack).effects().isEmpty()) {
            PlateComponentUtil.getFoodProperty(stack).effects().forEach(buff -> {
                int i = Mth.floor((float)((MobEffectInstance)buff.effectSupplier().get()).getDuration());
                MutableComponent component = Component.literal((String)StringUtil.formatTickDuration((int)i, (float)context.tickRate()));
                MobEffect mobEffect = (MobEffect)((MobEffectInstance)buff.effectSupplier().get()).getEffect().value();
                tooltipComponents.add((Component)Component.translatable((String)"item_text.customized.buff", (Object[])new Object[]{Component.translatable((String)mobEffect.getDescriptionId()).append((Component)Component.translatable((String)("enchantment.level." + (buff.effect().getAmplifier() + 1)))), component}).withStyle(mobEffect.getCategory().getTooltipFormatting()));
            });
        }
    }

    public abstract AbstractPotBlockEntity getPotEntity(Level var1, BlockPos var2);

    public int getIngredientInput() {
        return this.ingredientInput;
    }

    public int getSeasoningInput() {
        return this.seasoningInput;
    }

    public boolean isCanInputDrive() {
        return this.canInputDrive;
    }
}

