/*
 * Decompiled with CFR 0.152.
 */
package mangopill.customized.common.mixin;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Objects;
import mangopill.customized.common.registry.ModAdvancementRegistry;
import mangopill.customized.common.registry.ModParticleTypeRegistry;
import mangopill.customized.common.tag.ModTag;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemEntity.class})
public abstract class ItemReplaceMixin {
    private static final ResourceKey<LootTable> LOOT_TABLE = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"customized", (String)"gameplay/soiled_seed"));
    private int life = 200;

    @Inject(at={@At(value="HEAD")}, method={"tick"})
    public void customized$itemReplace(CallbackInfo ci) {
        ItemEntity itemEntity = (ItemEntity)this;
        ItemStack itemStack = itemEntity.getItem().copy();
        if (!itemStack.is(ModTag.SOILED_SEED) || !itemEntity.isInWaterRainOrBubble()) {
            return;
        }
        itemEntity.level().addParticle((ParticleOptions)ModParticleTypeRegistry.DIRT.get(), itemEntity.getX(), itemEntity.getY(), itemEntity.getZ(), 0.0, 0.0, 0.0);
        if (itemEntity.level().isClientSide() || itemEntity.level().getServer() == null) {
            return;
        }
        LootParams.Builder builder = new LootParams.Builder((ServerLevel)itemEntity.level());
        LootParams params = builder.create(LootContextParamSets.EMPTY);
        LootTable lootTable = Objects.requireNonNull(itemEntity.level().getServer()).reloadableRegistries().getLootTable(LOOT_TABLE);
        if (this.life > 0) {
            --this.life;
        } else {
            for (int i = 0; i < itemStack.getCount(); ++i) {
                ObjectArrayList objectArrayList = lootTable.getRandomItems(params);
                if (objectArrayList.isEmpty()) {
                    return;
                }
                ItemStack randomItem = ((ItemStack)objectArrayList.get(itemEntity.level().random.nextInt(objectArrayList.size()))).copy();
                ItemEntity newItemEntity = new ItemEntity(itemEntity.level(), itemEntity.getX(), itemEntity.getY(), itemEntity.getZ(), randomItem.copy());
                itemEntity.level().addFreshEntity((Entity)newItemEntity);
            }
            itemEntity.discard();
            Entity entity = itemEntity.getOwner();
            if (entity instanceof ServerPlayer) {
                ServerPlayer owner = (ServerPlayer)entity;
                ModAdvancementRegistry.WASH_SEEDS.get().trigger(owner);
            }
        }
    }
}

