/*
 * Decompiled with CFR 0.152.
 */
package mangopill.customized.common.recipe;

import java.util.List;
import mangopill.customized.common.recipe.ModRecipeInterface;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.RecipeMatcher;
import net.neoforged.neoforge.items.wrapper.RecipeWrapper;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractPotRecipe
implements ModRecipeInterface<RecipeWrapper> {
    private final NonNullList<Ingredient> ingredientItem;
    private final NonNullList<Ingredient> seasoningItem;
    private final Ingredient spiceItem;
    private final ItemStack output;
    private final int cookingTime;
    private final RecipeSerializer<?> recipeSerializer;
    private final RecipeType<?> recipeType;
    private final int ingredientInput;
    private final int seasoningInput;

    public AbstractPotRecipe(NonNullList<Ingredient> ingredientItem, NonNullList<Ingredient> seasoningItem, Ingredient spiceItem, ItemStack output, int cookingTime, RecipeSerializer<?> recipeSerializer, RecipeType<?> recipeType, int ingredientSlot, int seasoningSlot) {
        this.ingredientItem = ingredientItem;
        this.seasoningItem = seasoningItem;
        this.spiceItem = spiceItem;
        this.output = output;
        this.cookingTime = cookingTime;
        this.recipeSerializer = recipeSerializer;
        this.recipeType = recipeType;
        this.ingredientInput = ingredientSlot;
        this.seasoningInput = seasoningSlot;
    }

    public boolean matches(@NotNull RecipeWrapper recipeWrapper, @NotNull Level level) {
        List<ItemStack> ingredient = this.getListByWrapper(recipeWrapper, 0, this.ingredientInput);
        List<ItemStack> seasoning = this.getListByWrapper(recipeWrapper, this.ingredientInput, this.ingredientInput + this.seasoningInput);
        return ItemStack.isSameItem((ItemStack)this.spiceItem.getItems()[0], (ItemStack)recipeWrapper.getItem(this.ingredientInput + this.seasoningInput)) && ingredient.size() == this.ingredientItem.size() && seasoning.size() == this.seasoningItem.size() && RecipeMatcher.findMatches(ingredient, this.ingredientItem) != null && RecipeMatcher.findMatches(seasoning, this.seasoningItem) != null;
    }

    @NotNull
    public ItemStack assemble(@NotNull RecipeWrapper recipeWrapper, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        return this.output.copy();
    }

    @NotNull
    public ItemStack getResultItem(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        return this.output;
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        NonNullList combinedIngredient = NonNullList.create();
        combinedIngredient.addAll(this.ingredientItem);
        combinedIngredient.addAll(this.seasoningItem);
        if (this.spiceItem != null && !this.spiceItem.isEmpty()) {
            combinedIngredient.add((Object)this.spiceItem);
        }
        return combinedIngredient;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return this.recipeSerializer;
    }

    @NotNull
    public RecipeType<?> getType() {
        return this.recipeType;
    }

    public NonNullList<Ingredient> getIngredientItem() {
        return this.ingredientItem;
    }

    public NonNullList<Ingredient> getSeasoningItem() {
        return this.seasoningItem;
    }

    public Ingredient getSpiceItem() {
        return this.spiceItem;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public int getCookingTime() {
        return this.cookingTime;
    }
}

