/*
 * Decompiled with CFR 0.152.
 */
package mangopill.customized.common.recipe;

import java.util.List;
import mangopill.customized.common.recipe.ModRecipeInterface;
import mangopill.customized.common.registry.ModRecipeRegistry;
import mangopill.customized.common.registry.ModRecipeSerializerRegistry;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.RecipeMatcher;
import net.neoforged.neoforge.items.wrapper.RecipeWrapper;
import org.jetbrains.annotations.NotNull;

public class BrewingBarrelRecipe
implements ModRecipeInterface<RecipeWrapper> {
    private final NonNullList<Ingredient> ingredientItem;
    private final Ingredient containerItem;
    private final ItemStack output;
    private final int cookingTime;
    private final int ingredientInput;

    public BrewingBarrelRecipe(NonNullList<Ingredient> ingredientItem, Ingredient containerItem, ItemStack output, int cookingTime) {
        this.ingredientItem = ingredientItem;
        this.containerItem = containerItem;
        this.output = output;
        this.cookingTime = cookingTime;
        this.ingredientInput = 4;
    }

    public boolean matches(@NotNull RecipeWrapper recipeWrapper, @NotNull Level level) {
        List<ItemStack> ingredient = this.getListByWrapper(recipeWrapper, 0, this.ingredientInput);
        return ingredient.size() == this.ingredientItem.size() && RecipeMatcher.findMatches(ingredient, this.ingredientItem) != null;
    }

    @NotNull
    public ItemStack assemble(@NotNull RecipeWrapper recipeWrapper, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        return this.output.copy();
    }

    @NotNull
    public ItemStack getResultItem(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        return this.output;
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        return this.ingredientItem;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return ModRecipeSerializerRegistry.BREWING_BARREL.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return ModRecipeRegistry.BREWING_BARREL.get();
    }

    public NonNullList<Ingredient> getIngredientItem() {
        return this.ingredientItem;
    }

    public Ingredient getContainerItem() {
        return this.containerItem;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public int getCookingTime() {
        return this.cookingTime;
    }

    public int getIngredientInput() {
        return this.ingredientInput;
    }
}

