/*
 * Decompiled with CFR 0.152.
 */
package mangopill.customized.common.recipe.serializer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import mangopill.customized.common.recipe.BrewingBarrelRecipe;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.NotNull;

public class BrewingBarrelSerializer
implements RecipeSerializer<BrewingBarrelRecipe> {
    private static final MapCodec<BrewingBarrelRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.LIST_CODEC_NONEMPTY.fieldOf("ingredient").xmap(ingredient -> {
        NonNullList ingredientList = NonNullList.create();
        ingredientList.addAll((Collection)ingredient);
        return ingredientList;
    }, ingredient -> ingredient).forGetter(BrewingBarrelRecipe::getIngredientItem), (App)Ingredient.CODEC_NONEMPTY.fieldOf("container").forGetter(BrewingBarrelRecipe::getContainerItem), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(BrewingBarrelRecipe::getOutput), (App)Codec.INT.optionalFieldOf("time", (Object)200).forGetter(BrewingBarrelRecipe::getCookingTime)).apply((Applicative)instance, BrewingBarrelRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, BrewingBarrelRecipe> STREAM_CODEC = StreamCodec.of(BrewingBarrelSerializer::toNetwork, BrewingBarrelSerializer::fromNetwork);

    @NotNull
    public MapCodec<BrewingBarrelRecipe> codec() {
        return CODEC;
    }

    @NotNull
    public StreamCodec<RegistryFriendlyByteBuf, BrewingBarrelRecipe> streamCodec() {
        return STREAM_CODEC;
    }

    private static BrewingBarrelRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
        int ingredientLength = buffer.readVarInt();
        NonNullList ingredient = NonNullList.withSize((int)ingredientLength, (Object)Ingredient.EMPTY);
        ingredient.replaceAll(i -> (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer));
        Ingredient container = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
        ItemStack output = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
        int cookingTime = buffer.readVarInt();
        return new BrewingBarrelRecipe((NonNullList<Ingredient>)ingredient, container, output, cookingTime);
    }

    private static void toNetwork(RegistryFriendlyByteBuf buffer, BrewingBarrelRecipe recipe) {
        buffer.writeVarInt(recipe.getIngredientItem().size());
        for (Ingredient ingredient : recipe.getIngredientItem()) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)ingredient);
        }
        Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.getContainerItem());
        ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.getOutput());
        buffer.writeVarInt(recipe.getCookingTime());
    }
}

