/*
 * Decompiled with CFR 0.152.
 */
package mangopill.customized.common.recipe.serializer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import mangopill.customized.common.recipe.AbstractPotRecipe;
import mangopill.customized.common.recipe.CasseroleRecipe;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.NotNull;

public class CasseroleSerializer
implements RecipeSerializer<CasseroleRecipe> {
    private static final MapCodec<CasseroleRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.LIST_CODEC_NONEMPTY.fieldOf("ingredient").xmap(ingredient -> {
        NonNullList ingredientList = NonNullList.create();
        ingredientList.addAll((Collection)ingredient);
        return ingredientList;
    }, ingredient -> ingredient).forGetter(AbstractPotRecipe::getIngredientItem), (App)Ingredient.LIST_CODEC_NONEMPTY.fieldOf("seasoning").xmap(seasoning -> {
        NonNullList seasoningList = NonNullList.create();
        seasoningList.addAll((Collection)seasoning);
        return seasoningList;
    }, seasoning -> seasoning).forGetter(AbstractPotRecipe::getSeasoningItem), (App)Ingredient.CODEC_NONEMPTY.fieldOf("spice").forGetter(AbstractPotRecipe::getSpiceItem), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(AbstractPotRecipe::getOutput), (App)Codec.INT.optionalFieldOf("time", (Object)300).forGetter(AbstractPotRecipe::getCookingTime)).apply((Applicative)instance, CasseroleRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, CasseroleRecipe> STREAM_CODEC = StreamCodec.of(CasseroleSerializer::toNetwork, CasseroleSerializer::fromNetwork);

    @NotNull
    public MapCodec<CasseroleRecipe> codec() {
        return CODEC;
    }

    @NotNull
    public StreamCodec<RegistryFriendlyByteBuf, CasseroleRecipe> streamCodec() {
        return STREAM_CODEC;
    }

    private static CasseroleRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
        int ingredientLength = buffer.readVarInt();
        NonNullList ingredient = NonNullList.withSize((int)ingredientLength, (Object)Ingredient.EMPTY);
        ingredient.replaceAll(i -> (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer));
        int seasoningLength = buffer.readVarInt();
        NonNullList seasoning = NonNullList.withSize((int)seasoningLength, (Object)Ingredient.EMPTY);
        seasoning.replaceAll(j -> (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer));
        Ingredient spice = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
        ItemStack output = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
        int cookingTime = buffer.readVarInt();
        return new CasseroleRecipe((NonNullList<Ingredient>)ingredient, (NonNullList<Ingredient>)seasoning, spice, output, cookingTime);
    }

    private static void toNetwork(RegistryFriendlyByteBuf buffer, CasseroleRecipe recipe) {
        buffer.writeVarInt(recipe.getIngredientItem().size());
        for (Ingredient ingredient : recipe.getIngredientItem()) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)ingredient);
        }
        buffer.writeVarInt(recipe.getSeasoningItem().size());
        for (Ingredient ingredient : recipe.getSeasoningItem()) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)ingredient);
        }
        Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.getSpiceItem());
        ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.getOutput());
        buffer.writeVarInt(recipe.getCookingTime());
    }
}

