/*
 * Decompiled with CFR 0.152.
 */
package mangopill.customized.common.recipe.serializer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.IntStream;
import mangopill.customized.common.recipe.PropertyValueRecipe;
import mangopill.customized.common.util.value.PropertyValue;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.neoforged.neoforge.common.util.NeoForgeExtraCodecs;
import org.jetbrains.annotations.NotNull;

public class PropertyValueSerializer
implements RecipeSerializer<PropertyValueRecipe> {
    public static final MapCodec<PropertyValueRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)NeoForgeExtraCodecs.xor((MapCodec)NeoForgeExtraCodecs.setOf((Codec)ResourceLocation.CODEC).fieldOf("item"), (MapCodec)NeoForgeExtraCodecs.setOf((Codec)ResourceLocation.CODEC).fieldOf("tag")).forGetter(recipe -> recipe.item() ? Either.left(recipe.name()) : Either.right(recipe.name())), (App)PropertyValue.CODEC.fieldOf("value").forGetter(PropertyValueRecipe::propertyValue)).apply((Applicative)instance, (itemOrTag, propertyValue) -> {
        boolean isItem = itemOrTag.left().isPresent();
        Set name = isItem ? (Set)itemOrTag.left().get() : (Set)itemOrTag.right().get();
        return new PropertyValueRecipe(name, (PropertyValue)propertyValue, isItem);
    }));
    public static final StreamCodec<RegistryFriendlyByteBuf, PropertyValueRecipe> STREAM_CODEC = StreamCodec.of(PropertyValueSerializer::toNetwork, PropertyValueSerializer::fromNetwork);

    private static PropertyValueRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
        boolean isItem = buffer.readBoolean();
        HashSet<ResourceLocation> name = new HashSet<ResourceLocation>();
        int length = buffer.readVarInt();
        IntStream.range(0, length).forEach(i -> name.add(buffer.readResourceLocation()));
        PropertyValue propertyValue = (PropertyValue)PropertyValue.STREAM_CODEC.decode((Object)buffer);
        return new PropertyValueRecipe(name, propertyValue, isItem);
    }

    private static void toNetwork(RegistryFriendlyByteBuf buffer, PropertyValueRecipe recipe) {
        buffer.writeBoolean(recipe.item());
        buffer.writeVarInt(recipe.name().size());
        recipe.name().forEach(arg_0 -> ((RegistryFriendlyByteBuf)buffer).writeResourceLocation(arg_0));
        PropertyValue.STREAM_CODEC.encode((Object)buffer, (Object)recipe.propertyValue());
    }

    @NotNull
    public MapCodec<PropertyValueRecipe> codec() {
        return CODEC;
    }

    @NotNull
    public StreamCodec<RegistryFriendlyByteBuf, PropertyValueRecipe> streamCodec() {
        return STREAM_CODEC;
    }
}

