/*
 * Decompiled with CFR 0.152.
 */
package mangopill.customized.common.registry;

import java.util.function.Supplier;
import mangopill.customized.common.FoodValue;
import mangopill.customized.common.block.BitterGourdCropBlock;
import mangopill.customized.common.block.BrewingBarrelBlock;
import mangopill.customized.common.block.BroadBeanCropBlock;
import mangopill.customized.common.block.CasseroleBlock;
import mangopill.customized.common.block.ChilliCropBlock;
import mangopill.customized.common.block.FamousDishBlock;
import mangopill.customized.common.block.GingerCropBlock;
import mangopill.customized.common.block.ModBrushableBlock;
import mangopill.customized.common.block.RiceCropBlock;
import mangopill.customized.common.block.SaltPanBlock;
import mangopill.customized.common.block.ScallionCropBlock;
import mangopill.customized.common.block.SichuanPepperCropBlock;
import mangopill.customized.common.block.SoupBowlBlock;
import mangopill.customized.common.block.SoybeanCropBlock;
import mangopill.customized.common.block.TomatoCropBlock;
import mangopill.customized.common.util.RegistryUtil;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModBlockRegistry {
    public static final DeferredRegister<Block> BLOCK = DeferredRegister.create((ResourceKey)Registries.BLOCK, (String)"customized");
    public static final Supplier<Block> RICE_CROP = BLOCK.register("rice_crop", () -> new RiceCropBlock(RegistryUtil.cropBlockProperties()));
    public static final Supplier<Block> TOMATO_CROP = BLOCK.register("tomato_crop", () -> new TomatoCropBlock(RegistryUtil.cropBlockProperties()));
    public static final Supplier<Block> BITTER_GOURD_CROP = BLOCK.register("bitter_gourd_crop", () -> new BitterGourdCropBlock(RegistryUtil.cropBlockProperties()));
    public static final Supplier<Block> BROAD_BEAN_CROP = BLOCK.register("broad_bean_crop", () -> new BroadBeanCropBlock(RegistryUtil.cropBlockProperties()));
    public static final Supplier<Block> CHILLI_CROP = BLOCK.register("chilli_crop", () -> new ChilliCropBlock(RegistryUtil.cropBlockProperties()));
    public static final Supplier<Block> SOYBEAN_CROP = BLOCK.register("soybean_crop", () -> new SoybeanCropBlock(RegistryUtil.cropBlockProperties()));
    public static final Supplier<Block> SICHUAN_PEPPER_CROP = BLOCK.register("sichuan_pepper_crop", () -> new SichuanPepperCropBlock(RegistryUtil.cropBlockProperties()));
    public static final Supplier<Block> SCALLION_CROP = BLOCK.register("scallion_crop", () -> new ScallionCropBlock(RegistryUtil.cropBlockProperties()));
    public static final Supplier<Block> GINGER_CROP = BLOCK.register("ginger_crop", () -> new GingerCropBlock(RegistryUtil.cropBlockProperties()));
    public static final Supplier<Block> TOMATO_AND_BEEF_BRISKET_SOUP = BLOCK.register("tomato_and_beef_brisket_soup", () -> new FamousDishBlock(RegistryUtil.famousDishBlockProperties(), FoodValue.TOMATO_AND_BEEF_BRISKET_SOUP));
    public static final Supplier<Block> FISH_MAW_AND_CHICKEN_SOUP = BLOCK.register("fish_maw_and_chicken_soup", () -> new FamousDishBlock(RegistryUtil.famousDishBlockProperties(), FoodValue.FISH_MAW_AND_CHICKEN_SOUP));
    public static final Supplier<Block> BRAISED_CHICKEN_WITH_SHIITAKE_MUSHROOMS_SOUP = BLOCK.register("braised_chicken_with_shiitake_mushrooms_soup", () -> new FamousDishBlock(RegistryUtil.famousDishBlockProperties(), FoodValue.BRAISED_CHICKEN_WITH_SHIITAKE_MUSHROOMS_SOUP));
    public static final Supplier<Block> RADISH_AND_PORK_RIB_SOUP = BLOCK.register("radish_and_pork_rib_soup", () -> new FamousDishBlock(RegistryUtil.famousDishBlockProperties(), FoodValue.RADISH_AND_PORK_RIB_SOUP));
    public static final Supplier<Block> SUSPICIOUS_DIRT = BLOCK.register("suspicious_dirt", () -> new ModBrushableBlock(Blocks.DIRT, SoundEvents.BRUSH_GRAVEL, SoundEvents.BRUSH_GRAVEL_COMPLETED, BlockBehaviour.Properties.of().mapColor(MapColor.DIRT).instrument(NoteBlockInstrument.SNARE).strength(0.25f).sound(SoundType.SUSPICIOUS_GRAVEL).pushReaction(PushReaction.DESTROY)));
    public static final Supplier<Block> SALT_PAN = BLOCK.register("salt_pan", () -> new SaltPanBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS)));
    public static final Supplier<Block> CASSEROLE = BLOCK.register("casserole", () -> new CasseroleBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).strength(0.6f, 5.0f).sound(SoundType.DECORATED_POT)));
    public static final Supplier<Block> SOUP_BOWL = BLOCK.register("soup_bowl", () -> new SoupBowlBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).strength(0.3f, 2.0f).sound(SoundType.STONE)));
    public static final Supplier<Block> BREWING_BARREL = BLOCK.register("brewing_barrel", () -> new BrewingBarrelBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BARREL)));
}

