/*
 * Decompiled with CFR 0.152.
 */
package mangopill.customized.common.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import mangopill.customized.common.CustomizedConfig;
import mangopill.customized.common.FoodValue;
import mangopill.customized.common.effect.CombinationMobEffect;
import mangopill.customized.common.effect.ShrinkNutritionMobEffect;
import mangopill.customized.common.effect.ShrinkSaturationMobEffect;
import mangopill.customized.common.recipe.PropertyValueRecipe;
import mangopill.customized.common.registry.ModRecipeRegistry;
import mangopill.customized.common.util.ModItemStackHandlerHelper;
import mangopill.customized.common.util.category.NutrientCategory;
import mangopill.customized.common.util.value.NutrientBuff;
import mangopill.customized.common.util.value.NutrientFoodValue;
import mangopill.customized.common.util.value.PropertyValue;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PropertyValueUtil {
    private PropertyValueUtil() {
    }

    @NotNull
    public static PropertyValue getPropertyValue(ItemStack stack, Level level) {
        List recipeHolder = level.getRecipeManager().getRecipesFor(ModRecipeRegistry.PROPERTY_VALUE.get(), (RecipeInput)new SingleRecipeInput(stack), level);
        if (recipeHolder.isEmpty()) {
            return new PropertyValue();
        }
        return recipeHolder.stream().map(RecipeHolder::value).filter(PropertyValueRecipe::item).findFirst().map(PropertyValueRecipe::propertyValue).orElseGet(() -> {
            PropertyValue propertyValue = new PropertyValue();
            HashMap map = new HashMap();
            recipeHolder.stream().map(RecipeHolder::value).forEach(valueRecipe -> valueRecipe.name().forEach(name -> map.put(name, valueRecipe.propertyValue())));
            long maxCount = 0L;
            for (ResourceLocation tag : stack.getTags().map(TagKey::location).filter(map::containsKey).toList()) {
                long count = tag.getPath().chars().filter(c -> c == 47).count();
                if (count < maxCount) continue;
                if (count > maxCount) {
                    maxCount = count;
                    propertyValue.replace();
                }
                ((PropertyValue)map.get(tag)).toSet().forEach(entry -> propertyValue.put((NutrientCategory)((Object)((Object)((Object)entry.getKey()))), Math.max(propertyValue.getBigger((NutrientCategory)((Object)((Object)((Object)entry.getKey())))), ((Float)entry.getValue()).floatValue())));
            }
            return propertyValue;
        });
    }

    public static FoodProperties getFoodPropertyByPropertyValue(Level level, List<ItemStack> stackList, boolean shardByConsumption) {
        FoodProperties.Builder builder;
        block20: {
            float saturationValue;
            int nutritionValue;
            ArrayList<FoodProperties.PossibleEffect> foodEffect;
            block19: {
                if (stackList == null || stackList.isEmpty()) {
                    return FoodValue.NULL;
                }
                EnumMap<NutrientCategory, Float> nutrientTotal = new EnumMap<NutrientCategory, Float>(NutrientCategory.class);
                for (NutrientCategory category : NutrientCategory.values()) {
                    nutrientTotal.put(category, Float.valueOf(0.0f));
                }
                foodEffect = new ArrayList<FoodProperties.PossibleEffect>();
                nutritionValue = 0;
                saturationValue = 0.0f;
                for (ItemStack stack : stackList) {
                    NutrientFoodValue @NotNull [] propertyValue = PropertyValueUtil.getPropertyValue(stack, level);
                    FoodProperties food = stack.getFoodProperties(null);
                    if (food != null && !food.effects().isEmpty()) {
                        foodEffect.addAll(food.effects());
                    }
                    if (!propertyValue.isEmpty()) {
                        for (Pair<NutrientCategory, Float> entry : propertyValue.toSet()) {
                            NutrientCategory category = (NutrientCategory)((Object)entry.getKey());
                            float value = ((Float)entry.getValue()).floatValue() * (float)stack.getCount();
                            nutrientTotal.put(category, Float.valueOf(((Float)nutrientTotal.get((Object)category)).floatValue() + value));
                        }
                        continue;
                    }
                    if (food != null) {
                        nutritionValue += food.nutrition() * stack.getCount();
                        saturationValue += food.saturation() * (float)stack.getCount();
                        continue;
                    }
                    return FoodValue.INEDIBLE;
                }
                for (NutrientCategory category : nutrientTotal.keySet()) {
                    for (NutrientFoodValue value : NutrientFoodValue.values()) {
                        if (!category.name().equals(value.name())) continue;
                        nutritionValue += (int)Math.round((double)((Float)nutrientTotal.get((Object)category)).floatValue() * value.getNutrition());
                        saturationValue += (float)((double)((Float)nutrientTotal.get((Object)category)).floatValue() * value.getSaturation());
                    }
                }
                if (((Boolean)CustomizedConfig.COMBINATION_BUFF.get()).booleanValue()) {
                    nutritionValue = Math.max(0, (int)((float)nutritionValue - (float)nutritionValue * PropertyValueUtil.getShrinkNutrition(nutrientTotal)));
                    saturationValue = Math.max(0.0f, saturationValue - saturationValue * PropertyValueUtil.getShrinkSaturation(nutrientTotal));
                }
                builder = new FoodProperties.Builder();
                foodEffect.addAll(PropertyValueUtil.getCustomizedFoodEffectList(nutrientTotal));
                if (!shardByConsumption) break block19;
                int consumptionCount = ModItemStackHandlerHelper.getConsumptionCount(stackList);
                if (consumptionCount != 0) {
                    builder.nutrition(nutritionValue / consumptionCount);
                } else {
                    builder.nutrition(0);
                }
                if (nutritionValue != 0) {
                    BigDecimal newSaturationValue = new BigDecimal(saturationValue).divide(BigDecimal.valueOf(nutritionValue), 6, RoundingMode.HALF_UP).divide(BigDecimal.valueOf(consumptionCount), 5, RoundingMode.HALF_UP);
                    builder.saturationModifier(newSaturationValue.floatValue() * 12.0f);
                } else {
                    builder.saturationModifier(saturationValue / (float)consumptionCount);
                }
                if (foodEffect.isEmpty()) break block20;
                for (FoodProperties.PossibleEffect pair : foodEffect) {
                    builder.effect(pair.effectSupplier(), pair.probability());
                }
                break block20;
            }
            builder.nutrition(nutritionValue);
            if (nutritionValue != 0) {
                BigDecimal newSaturationValue = new BigDecimal(saturationValue).divide(BigDecimal.valueOf(nutritionValue), 5, RoundingMode.HALF_UP);
                builder.saturationModifier(newSaturationValue.floatValue() * 12.0f);
            } else {
                builder.saturationModifier(saturationValue);
            }
            if (!foodEffect.isEmpty()) {
                for (FoodProperties.PossibleEffect pair : foodEffect) {
                    builder.effect(pair.effectSupplier(), pair.probability());
                }
            }
        }
        return builder.alwaysEdible().build();
    }

    public static List<FoodProperties.PossibleEffect> getCustomizedFoodEffectList(Map<NutrientCategory, Float> nutrientTotal) {
        Map<NutrientCategory, Float> filteredNutrientTotal = PropertyValueUtil.getFilteredNutrientTotal(nutrientTotal);
        ArrayList<FoodProperties.PossibleEffect> foodEffect = new ArrayList<FoodProperties.PossibleEffect>();
        for (NutrientCategory category : filteredNutrientTotal.keySet()) {
            float nutrientValue = filteredNutrientTotal.get((Object)category).floatValue();
            if (((Boolean)CustomizedConfig.NORMAL_BUFF.get()).booleanValue()) {
                PropertyValueUtil.addBuffToList(nutrientValue, foodEffect, PropertyValueUtil.getNormalBuff(category));
            }
            if (!((Boolean)CustomizedConfig.POWERFUL_BUFF.get()).booleanValue()) continue;
            PropertyValueUtil.addBuffToList(nutrientValue, foodEffect, PropertyValueUtil.getPowerfulBuff(category));
        }
        if (((Boolean)CustomizedConfig.COMBINATION_BUFF.get()).booleanValue()) {
            Map<NutrientBuff, Float> combinationBuff = PropertyValueUtil.getCombinationBuffMap(filteredNutrientTotal);
            combinationBuff.forEach((n, f) -> PropertyValueUtil.addBuffToList(f.floatValue(), foodEffect, n));
        }
        return foodEffect;
    }

    @NotNull
    public static Map<NutrientCategory, Float> getFilteredNutrientTotal(Map<NutrientCategory, Float> nutrientTotal) {
        return nutrientTotal.entrySet().stream().filter(entry -> ((Float)entry.getValue()).floatValue() > 0.0f).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static Map<NutrientBuff, Float> getCombinationBuffMap(Map<NutrientCategory, Float> filteredNutrientTotal) {
        HashMap<NutrientBuff, Float> combinationBuff = new HashMap<NutrientBuff, Float>();
        EnumSet<NutrientBuff> nutrientTotal = EnumSet.allOf(NutrientBuff.class);
        Set<NutrientCategory> saturation1 = Set.of(NutrientCategory.WATER, NutrientCategory.PROTEIN);
        Set<NutrientCategory> saturation2 = Set.of(NutrientCategory.WATER, NutrientCategory.DIETARY_FIBER);
        PropertyValueUtil.putCombinationBuffByContains(filteredNutrientTotal, combinationBuff, NutrientBuff.SATURATION, List.of(saturation1, saturation2));
        nutrientTotal.forEach(nutrientBuff -> {
            Object patt0$temp = nutrientBuff.getEffect().value();
            if (patt0$temp instanceof CombinationMobEffect) {
                CombinationMobEffect combinationMobEffect = (CombinationMobEffect)patt0$temp;
                PropertyValueUtil.putCombinationBuffByContains(filteredNutrientTotal, combinationBuff, nutrientBuff, combinationMobEffect.getCategorySet());
            }
        });
        return combinationBuff;
    }

    public static float getShrinkNutrition(Map<NutrientCategory, Float> nutrientTotal) {
        Map<NutrientBuff, Float> buffMap = PropertyValueUtil.getCombinationBuffMap(PropertyValueUtil.getFilteredNutrientTotal(nutrientTotal));
        float i = 0.0f;
        for (NutrientBuff nutrient : buffMap.keySet()) {
            Object object = nutrient.getEffect().value();
            if (!(object instanceof ShrinkNutritionMobEffect)) continue;
            ShrinkNutritionMobEffect effect = (ShrinkNutritionMobEffect)object;
            i += effect.getShrinkNutritionModifier();
        }
        return i;
    }

    public static float getShrinkSaturation(Map<NutrientCategory, Float> nutrientTotal) {
        Map<NutrientBuff, Float> buffMap = PropertyValueUtil.getCombinationBuffMap(PropertyValueUtil.getFilteredNutrientTotal(nutrientTotal));
        float i = 0.0f;
        for (NutrientBuff nutrient : buffMap.keySet()) {
            Object object = nutrient.getEffect().value();
            if (!(object instanceof ShrinkSaturationMobEffect)) continue;
            ShrinkSaturationMobEffect effect = (ShrinkSaturationMobEffect)object;
            i += effect.getShrinkSaturationModifier();
        }
        return i;
    }

    public static void putCombinationBuffByContains(Map<NutrientCategory, Float> filteredNutrientTotal, Map<NutrientBuff, Float> combinationBuffMap, NutrientBuff combinationBuff, List<Set<NutrientCategory>> sets) {
        for (Set<NutrientCategory> set : sets) {
            if (!filteredNutrientTotal.keySet().containsAll(set)) continue;
            float totalValue = (float)filteredNutrientTotal.entrySet().stream().filter(entry -> set.contains(entry.getKey())).mapToDouble(Map.Entry::getValue).sum();
            combinationBuffMap.put(combinationBuff, Float.valueOf(totalValue));
        }
    }

    public static void addBuffToList(float nutrientValue, List<FoodProperties.PossibleEffect> foodEffect, NutrientBuff nutrientBuff) {
        if (nutrientBuff == null) {
            return;
        }
        int duration = Math.round(nutrientValue * 10.0f * (float)nutrientBuff.getDuration());
        float probability = (float)((double)(nutrientValue * 10.0f) * nutrientBuff.getProbability());
        foodEffect.add(new FoodProperties.PossibleEffect(() -> new MobEffectInstance(nutrientBuff.getEffect(), duration, 0), Math.min(probability, 1.0f)));
    }

    @Nullable
    public static NutrientBuff getNormalBuff(NutrientCategory category) {
        return switch (category) {
            case NutrientCategory.COLD -> NutrientBuff.ICED;
            case NutrientCategory.WARM -> NutrientBuff.WARM_STOMACH;
            default -> null;
        };
    }

    @Nullable
    public static NutrientBuff getPowerfulBuff(NutrientCategory category) {
        return switch (category) {
            case NutrientCategory.ECOLOGY -> NutrientBuff.VITALITY;
            case NutrientCategory.DREAD -> NutrientBuff.ANTIDOTE;
            case NutrientCategory.NOTHINGNESS -> NutrientBuff.SOAR;
            default -> null;
        };
    }
}

