/*
 * Decompiled with CFR 0.152.
 */
package mangopill.customized.common.util;

import java.util.function.Supplier;
import mangopill.customized.common.FoodValue;
import mangopill.customized.common.registry.ModDataComponentRegistry;
import mangopill.customized.common.registry.ModItemRegistry;
import mangopill.customized.common.util.record.ItemStackHandlerRecord;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.registries.DeferredItem;

public final class RegistryUtil {
    private RegistryUtil() {
    }

    public static Item.Properties basicItemProperties() {
        return new Item.Properties();
    }

    public static Item.Properties basicPlateItemProperties(int slot) {
        return RegistryUtil.basicItemProperties().stacksTo(1).food(FoodValue.NULL).component(ModDataComponentRegistry.ITEM_STACK_HANDLER, (Object)new ItemStackHandlerRecord(new ItemStackHandler(slot)));
    }

    public static Supplier<Item> basicItem() {
        return () -> new Item(RegistryUtil.basicItemProperties());
    }

    public static Supplier<Item> basicFoodItem(FoodProperties foodProperties) {
        return () -> new Item(RegistryUtil.basicItemProperties().food(foodProperties));
    }

    public static Supplier<Item> drinkItem(FoodProperties foodProperties) {
        return () -> new Item(RegistryUtil.basicItemProperties().food(foodProperties).craftRemainder(Items.GLASS_BOTTLE).stacksTo(16));
    }

    public static Supplier<Item> blockItem(Supplier<Block> supplier, Item.Properties properties) {
        return () -> new BlockItem((Block)supplier.get(), properties);
    }

    public static Supplier<Item> itemNameBlockItem(Supplier<Block> supplier, Item.Properties properties) {
        return () -> new ItemNameBlockItem((Block)supplier.get(), properties);
    }

    public static Supplier<Item> foodSeedItem(Supplier<Block> supplier, FoodProperties foodProperties) {
        return RegistryUtil.itemNameBlockItem(supplier, RegistryUtil.basicItemProperties().food(foodProperties));
    }

    public static BlockBehaviour.Properties cropBlockProperties() {
        return BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHEAT);
    }

    public static BlockBehaviour.Properties famousDishBlockProperties() {
        return BlockBehaviour.Properties.of().mapColor(MapColor.QUARTZ).instrument(NoteBlockInstrument.SNARE).strength(0.2f).sound(SoundType.STONE).pushReaction(PushReaction.BLOCK);
    }

    public static <T extends BlockEntity> Supplier<BlockEntityType<T>> basicBlockEntityType(BlockEntityType.BlockEntitySupplier<T> blockEntityType, Supplier<Block> supplier) {
        return () -> BlockEntityType.Builder.of((BlockEntityType.BlockEntitySupplier)blockEntityType, (Block[])new Block[]{(Block)supplier.get()}).build(null);
    }

    public static Supplier<Item> registerWithCreativeTab(String string, Supplier<Item> supplier) {
        DeferredItem register = ModItemRegistry.ITEM.register(string, supplier);
        ModItemRegistry.CREATIVE_MODE_TAB.add((Supplier<Item>)register);
        return register;
    }

    public static <T extends Recipe<?>> RecipeType<T> registerRecipeType(final String s) {
        return new RecipeType<T>(){

            public String toString() {
                return "customized:" + s;
            }
        };
    }
}

