/*
 * Decompiled with CFR 0.152.
 */
package mangopill.customized.common.util.record;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.ItemStackHandler;

public record ItemStackHandlerRecord(ItemStackHandler itemStackHandler) {
    public static final ItemStackHandlerRecord NULL = new ItemStackHandlerRecord(new ItemStackHandler());
    public static final Codec<ItemStackHandler> ITEM_STACK_HANDLER_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("Slots").forGetter(ItemStackHandler::getSlots), (App)Codec.list((Codec)ItemStack.OPTIONAL_CODEC).fieldOf("Items").forGetter(handler -> {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < handler.getSlots(); ++i) {
            stacks.add(handler.getStackInSlot(i).copy());
        }
        return stacks;
    })).apply((Applicative)instance, (slots, items) -> {
        ItemStackHandler handler = new ItemStackHandler(slots.intValue());
        for (int i = 0; i < items.size(); ++i) {
            handler.setStackInSlot(i, ((ItemStack)items.get(i)).copy());
        }
        return handler;
    }));
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemStackHandler> ITEM_STACK_HANDLER_STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, ItemStackHandler::getSlots, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC.apply(ByteBufCodecs.list()), handler -> {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < handler.getSlots(); ++i) {
            stacks.add(handler.getStackInSlot(i).copy());
        }
        return stacks;
    }, (slots, items) -> {
        ItemStackHandler handler = new ItemStackHandler(slots.intValue());
        for (int i = 0; i < items.size(); ++i) {
            handler.setStackInSlot(i, ((ItemStack)items.get(i)).copy());
        }
        return handler;
    });
    public static final Codec<ItemStackHandlerRecord> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ITEM_STACK_HANDLER_CODEC.fieldOf("item_stack_handler").forGetter(ItemStackHandlerRecord::itemStackHandler)).apply((Applicative)instance, ItemStackHandlerRecord::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemStackHandlerRecord> STREAM_CODEC = StreamCodec.composite(ITEM_STACK_HANDLER_STREAM_CODEC, ItemStackHandlerRecord::itemStackHandler, ItemStackHandlerRecord::new);
}

