/*
 * Decompiled with CFR 0.152.
 */
package mangopill.customized.common.util.value;

import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import mangopill.customized.common.util.category.NutrientCategory;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class PropertyValue {
    private static final NutrientCategory[] CATEGORY = NutrientCategory.values();
    private final float[] value = new float[CATEGORY.length];
    private int size;
    public static final Codec<NutrientCategory> CATEGORY_CODEC = StringRepresentable.fromEnum(NutrientCategory::values);
    public static final Codec<PropertyValue> CODEC = Codec.unboundedMap(CATEGORY_CODEC, (Codec)Codec.FLOAT).xmap(PropertyValue::putToMap, propertyValues -> propertyValues.toSet().stream().collect(Collectors.toUnmodifiableMap(Pair::getKey, Pair::getValue)));
    public static final StreamCodec<FriendlyByteBuf, PropertyValue> STREAM_CODEC = StreamCodec.of(PropertyValue::toNetwork, PropertyValue::fromNetwork);

    public static PropertyValue putToMap(@NotNull Map<NutrientCategory, Float> map) {
        PropertyValue propertyValue = new PropertyValue();
        map.forEach(propertyValue::put);
        return propertyValue;
    }

    public boolean has(@NotNull NutrientCategory category) {
        return this.value[category.ordinal()] > 0.0f;
    }

    public boolean notHas(@NotNull NutrientCategory category) {
        return !this.has(category);
    }

    public void put(@NotNull NutrientCategory category, float value) {
        if (Float.isNaN(value) || value <= 0.0f) {
            this.remove(category);
            return;
        }
        if (this.notHas(category)) {
            ++this.size;
        }
        this.value[category.ordinal()] = value;
    }

    public void remove(@NotNull NutrientCategory category) {
        if (this.notHas(category)) {
            return;
        }
        this.value[category.ordinal()] = 0.0f;
        --this.size;
    }

    public Set<Pair<NutrientCategory, Float>> toSet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (NutrientCategory category : CATEGORY) {
            if (!(this.value[category.ordinal()] > 0.0f)) continue;
            builder.add((Object)Pair.of((Object)((Object)category), (Object)Float.valueOf(this.value[category.ordinal()])));
        }
        return builder.build();
    }

    private static PropertyValue fromNetwork(FriendlyByteBuf buffer) {
        PropertyValue propertyValue = new PropertyValue();
        byte length = buffer.readByte();
        IntStream.range(0, length).forEach(i -> {
            NutrientCategory category = (NutrientCategory)buffer.readEnum(NutrientCategory.class);
            float value = buffer.readFloat();
            propertyValue.put(category, value);
        });
        return propertyValue;
    }

    private static void toNetwork(FriendlyByteBuf buffer, PropertyValue value) {
        Set<Pair<NutrientCategory, Float>> entrySet = value.toSet();
        buffer.writeByte(entrySet.size());
        entrySet.forEach(entry -> {
            buffer.writeEnum((Enum)entry.getKey());
            buffer.writeFloat(((Float)entry.getValue()).floatValue());
        });
    }

    public boolean isEmpty() {
        return this.size <= 0;
    }

    public void replace() {
        Arrays.fill(this.value, 0.0f);
        this.size = 0;
    }

    public float getBigger(@NotNull NutrientCategory category) {
        return Math.max(this.value[category.ordinal()], 0.0f);
    }

    public static NutrientCategory[] getCategory() {
        return CATEGORY;
    }

    public float[] getValue() {
        return this.value;
    }

    public int getSize() {
        return this.size;
    }
}

