/*
 * Decompiled with CFR 0.152.
 */
package mangopill.customized.common.world.feature;

import com.mojang.serialization.Codec;
import mangopill.customized.common.registry.ModBlockEntityTypeRegistry;
import mangopill.customized.common.registry.ModBlockRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.storage.loot.LootTable;

public class FlowerAndDirtFeature
extends Feature<NoneFeatureConfiguration> {
    private static final ResourceKey<LootTable> LOOT_TABLE = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"customized", (String)"archaeology/flower_and_dirt"));
    private static final BlockStatePredicate IS_GRASS_BLOCK = BlockStatePredicate.forBlock((Block)Blocks.GRASS_BLOCK);
    private final BlockState BLUE_ORCHID = Blocks.BLUE_ORCHID.defaultBlockState();

    public FlowerAndDirtFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        BlockPos blockpos;
        WorldGenLevel worldgenlevel = context.level();
        if (IS_GRASS_BLOCK.test(worldgenlevel.getBlockState(blockpos = context.origin().below()))) {
            worldgenlevel.setBlock(blockpos.above(), this.BLUE_ORCHID, 2);
            FlowerAndDirtFeature.placeSusDirt(worldgenlevel, blockpos.below());
            return true;
        }
        return false;
    }

    private static void placeSusDirt(WorldGenLevel level, BlockPos pos) {
        level.setBlock(pos, ModBlockRegistry.SUSPICIOUS_DIRT.get().defaultBlockState(), 3);
        level.getBlockEntity(pos, ModBlockEntityTypeRegistry.SUSPICIOUS_DIRT.get()).ifPresent(Consumer2 -> Consumer2.setLootTable(LOOT_TABLE, pos.asLong()));
    }
}

