/*
 * Decompiled with CFR 0.152.
 */
package mangopill.customized.integration.jei.category;

import java.util.ArrayList;
import mangopill.customized.common.recipe.BrewingBarrelRecipe;
import mangopill.customized.common.registry.ModBlockRegistry;
import mangopill.customized.common.registry.ModItemRegistry;
import mangopill.customized.integration.jei.util.JeiUtil;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BrewingBarrelRecipeCategory
implements IRecipeCategory<BrewingBarrelRecipe> {
    private final Component title = Component.translatable((String)ModBlockRegistry.BREWING_BARREL.get().getDescriptionId());
    private final IDrawable background;
    private final IDrawable icon;

    public BrewingBarrelRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(ResourceLocation.fromNamespaceAndPath((String)"customized", (String)"textures/gui/brewing_barrel.png"), 4, 4, 54, 41);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModItemRegistry.BREWING_BARREL.get()));
    }

    @NotNull
    public RecipeType<BrewingBarrelRecipe> getRecipeType() {
        return JeiUtil.BREWING_BARREL;
    }

    @NotNull
    public Component getTitle() {
        return this.title;
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull BrewingBarrelRecipe recipe, @NotNull IFocusGroup focuses) {
        int slotSize = 18;
        for (int row = 0; row < 2; ++row) {
            for (int col = 0; col < 2; ++col) {
                int index = row * 2 + col;
                if (index >= recipe.getIngredientItem().size()) continue;
                builder.addSlot(RecipeIngredientRole.INPUT, col * slotSize + 1, row * slotSize + 1).addIngredients((Ingredient)recipe.getIngredientItem().get(index));
            }
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 37, 19).addItemStack(recipe.getOutput());
    }

    public void getTooltip(@NotNull ITooltipBuilder tooltip, @NotNull BrewingBarrelRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        ArrayList<MutableComponent> tooltipString = new ArrayList<MutableComponent>();
        if (JeiUtil.canAddTooltip(mouseX, mouseY, 38.0, 3.0, 11.0, 13.0)) {
            tooltipString.add(Component.translatable((String)"gui.jei.customized.cook_time", (Object[])new Object[]{recipe.getCookingTime() * 13 / 20}));
        }
        if (JeiUtil.canAddTooltip(mouseX, mouseY, 41.0, 37.0, 8.0, 4.0)) {
            tooltipString.add(Component.translatable((String)"gui.jei.customized.container", (Object[])new Object[]{Component.translatable((String)recipe.getContainerItem().getItems()[0].getDescriptionId())}));
        }
        tooltip.addAll(tooltipString);
    }
}

