/*
 * Decompiled with CFR 0.152.
 */
package mangopill.customized.integration.jei.util;

import java.util.List;
import java.util.function.Supplier;
import mangopill.customized.common.recipe.BrewingBarrelRecipe;
import mangopill.customized.common.recipe.CasseroleRecipe;
import mangopill.customized.common.registry.ModItemRegistry;
import mangopill.customized.common.registry.ModRecipeRegistry;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public final class JeiUtil {
    public static final RecipeType<CasseroleRecipe> CASSEROLE = RecipeType.create((String)"customized", (String)"casserole", CasseroleRecipe.class);
    public static final RecipeType<BrewingBarrelRecipe> BREWING_BARREL = RecipeType.create((String)"customized", (String)"brewing_barrel", BrewingBarrelRecipe.class);

    private JeiUtil() {
    }

    public static List<CasseroleRecipe> getCasseroleRecipeList() {
        return Minecraft.getInstance().level.getRecipeManager().getAllRecipesFor(ModRecipeRegistry.CASSEROLE.get()).stream().map(RecipeHolder::value).toList();
    }

    public static List<BrewingBarrelRecipe> getBrewingBarrelRecipeList() {
        return Minecraft.getInstance().level.getRecipeManager().getAllRecipesFor(ModRecipeRegistry.BREWING_BARREL.get()).stream().map(RecipeHolder::value).toList();
    }

    public static boolean canAddTooltip(double mouseX, double mouseY, double xStart, double yStart, double width, double height) {
        return mouseX >= xStart && mouseX <= xStart + width && mouseY >= yStart && mouseY <= yStart + height;
    }

    public static void setPotRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull CasseroleRecipe recipe, int slotSize, int slotCount1, int slotCount2, int lineSpacing, int spiceXStart, int spiceYStart, int outputXStart, int outputYStart) {
        int col;
        for (col = 0; col < slotCount1; ++col) {
            if (col >= recipe.getIngredientItem().size()) continue;
            builder.addSlot(RecipeIngredientRole.INPUT, col * slotSize + 1, 1).addIngredients((Ingredient)recipe.getIngredientItem().get(col));
        }
        for (col = 0; col < slotCount2; ++col) {
            if (col >= recipe.getSeasoningItem().size()) continue;
            builder.addSlot(RecipeIngredientRole.INPUT, col * slotSize + 1, slotSize + lineSpacing + 1).addIngredients((Ingredient)recipe.getSeasoningItem().get(col));
        }
        builder.addSlot(RecipeIngredientRole.INPUT, spiceXStart, spiceYStart).addIngredients(recipe.getSpiceItem());
        builder.addSlot(RecipeIngredientRole.OUTPUT, outputXStart, outputYStart).addItemStack(recipe.getOutput());
    }

    public static void addPotTooltip(@NotNull CasseroleRecipe recipe, double mouseX, double mouseY, List<Component> tooltipString, int timeXStart, int timeYStart, int timeWidth, int timeHeight, int fireXStart, int fireYStart, int fireWidth, int fireHeight, int containerXStart, int containerYStart, int containerWidth, int containerHeight) {
        if (JeiUtil.canAddTooltip(mouseX, mouseY, timeXStart, timeYStart, timeWidth, timeHeight)) {
            tooltipString.add((Component)Component.translatable((String)"gui.jei.customized.cook_time", (Object[])new Object[]{recipe.getCookingTime() / 20}));
        }
        if (JeiUtil.canAddTooltip(mouseX, mouseY, fireXStart, fireYStart, fireWidth, fireHeight)) {
            tooltipString.add((Component)Component.translatable((String)"gui.jei.customized.fire"));
        }
        if (JeiUtil.canAddTooltip(mouseX, mouseY, containerXStart, containerYStart, containerWidth, containerHeight)) {
            tooltipString.add((Component)Component.translatable((String)"gui.jei.customized.container", (Object[])new Object[]{Component.translatable((String)ModItemRegistry.FAMOUS_DISH_PLATE.get().getDescriptionId())}));
        }
    }

    public static void addJeiInfo(@NotNull IRecipeRegistration registration, Supplier<Item> item, String s) {
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)item.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)("jei.info.customized" + s))});
    }
}

