/*
 * Decompiled with CFR 0.152.
 */
package mangopill.customized.client.event;

import mangopill.customized.client.event.renderer.BrewingBarrelBlockRenderer;
import mangopill.customized.client.event.renderer.CasseroleBlockRenderer;
import mangopill.customized.client.event.renderer.ModBrushableBlockRenderer;
import mangopill.customized.client.event.renderer.SoupBowlBlockRenderer;
import mangopill.customized.client.event.tinting.Tinting;
import mangopill.customized.client.particle.AromaParticle;
import mangopill.customized.client.particle.DirtParticle;
import mangopill.customized.client.particle.SteamParticle;
import mangopill.customized.common.item.SoupBowlItem;
import mangopill.customized.common.registry.ModAdvancementRegistry;
import mangopill.customized.common.registry.ModBlockEntityTypeRegistry;
import mangopill.customized.common.registry.ModBlockRegistry;
import mangopill.customized.common.registry.ModItemRegistry;
import mangopill.customized.common.registry.ModParticleTypeRegistry;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="customized", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientEvent {
    @SubscribeEvent
    public static void registerOverride(FMLClientSetupEvent event) {
        event.enqueueWork(() -> ItemProperties.register((Item)ModItemRegistry.SOUP_BOWL.get(), (ResourceLocation)ModAdvancementRegistry.getId("drive"), (stack, level, player, seed) -> stack.m_41720_() instanceof SoupBowlItem ? (((SoupBowlItem)stack.m_41720_()).hasInput(stack) ? 1.0f : 0.0f) : 0.0f));
    }

    @SubscribeEvent
    public static void registerAdditional(ModelEvent.RegisterAdditional event) {
        event.register((ResourceLocation)new ModelResourceLocation("customized", "soup_bowl_with_drive_renderer", "inventory"));
    }

    @SubscribeEvent
    public static void onRegisterRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer(ModBlockEntityTypeRegistry.SUSPICIOUS_DIRT.get(), ModBrushableBlockRenderer::new);
        event.registerBlockEntityRenderer(ModBlockEntityTypeRegistry.CASSEROLE.get(), CasseroleBlockRenderer::new);
        event.registerBlockEntityRenderer(ModBlockEntityTypeRegistry.SOUP_BOWL.get(), SoupBowlBlockRenderer::new);
        event.registerBlockEntityRenderer(ModBlockEntityTypeRegistry.BREWING_BARREL.get(), BrewingBarrelBlockRenderer::new);
    }

    @SubscribeEvent
    public static void registerParticleProviders(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)ModParticleTypeRegistry.DIRT.get(), DirtParticle.DirtParticleProvider::new);
        event.registerSpriteSet((ParticleType)ModParticleTypeRegistry.STEAM.get(), SteamParticle.SteamParticleProvider::new);
        event.registerSpriteSet((ParticleType)ModParticleTypeRegistry.AROMA.get(), AromaParticle.AromaParticleProvider::new);
    }

    @SubscribeEvent
    public static void registerBlockColorHandlers(RegisterColorHandlersEvent.Block event) {
        event.register((state, level, pos, tintIndex) -> level == null || pos == null ? -1 : Tinting.getPotWaterColor(level, state, pos), new Block[]{ModBlockRegistry.CASSEROLE.get()});
        event.register((state, level, pos, tintIndex) -> level == null || pos == null ? -1 : Tinting.getPlateBlockWaterColor(level, state, pos), new Block[]{ModBlockRegistry.SOUP_BOWL.get()});
    }

    @SubscribeEvent
    public static void registerItemColorHandlers(RegisterColorHandlersEvent.Item event) {
        event.register((stack, tintIndex) -> Tinting.getPlateItemWaterColor(stack), new ItemLike[]{(ItemLike)ModItemRegistry.SOUP_BOWL.get()});
    }
}

