/*
 * Decompiled with CFR 0.152.
 */
package mangopill.customized.client.event.tooltip;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.Collections;
import mangopill.customized.common.CustomizedConfig;
import mangopill.customized.common.FoodValue;
import mangopill.customized.common.tag.ModTag;
import mangopill.customized.common.util.PropertyValueUtil;
import mangopill.customized.common.util.category.NutrientCategory;
import mangopill.customized.common.util.value.PropertyValue;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="customized", value={Dist.CLIENT})
public class PropertyValueTooltip {
    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        Player player = event.getEntity();
        ItemStack stack = event.getItemStack();
        if (player == null || player.m_9236_() == null) {
            return;
        }
        PropertyValue propertyValue = PropertyValueUtil.getPropertyValue(stack, player.m_9236_());
        FoodProperties foodProperty = PropertyValueUtil.getFoodPropertyByPropertyValue(player.m_9236_(), Collections.singletonList(stack), false);
        if (propertyValue.isEmpty()) {
            return;
        }
        if (!PropertyValueTooltip.isCtrlKeyPressed() && PropertyValueTooltip.canShow()) {
            event.getToolTip().add(Component.m_237115_((String)"tooltip.customized.is_ctrl_key_pressed").m_130940_(ChatFormatting.DARK_GRAY));
            return;
        }
        if (((Boolean)CustomizedConfig.SHOW_NUTRIENT_VALUE_TOOLTIP.get()).booleanValue()) {
            PropertyValueTooltip.addFoodCategory(event, stack);
            propertyValue.toSet().forEach(entry -> {
                MutableComponent propertyComponent = Component.m_237110_((String)"tooltip.customized.property_value", (Object[])new Object[]{Component.m_237115_((String)("property.customized.nutrient_category." + ((NutrientCategory)((Object)((Object)entry.getKey()))).m_7912_())), entry.getValue()}).m_130948_(Style.f_131099_.m_131148_(((NutrientCategory)((Object)((Object)entry.getKey()))).getColor())).m_130946_("%");
                event.getToolTip().add(propertyComponent);
            });
        }
        if (foodProperty.equals(FoodValue.NULL)) {
            return;
        }
        if (((Boolean)CustomizedConfig.SHOW_ESTIMATED_VALUE_TOOLTIP.get()).booleanValue()) {
            MutableComponent estimatedComponent = Component.m_237110_((String)"tooltip.customized.estimated_value", (Object[])new Object[]{Component.m_237115_((String)"estimated.customized.nutritional_value"), foodProperty.m_38744_(), Float.valueOf(foodProperty.m_38745_())}).m_130940_(ChatFormatting.GREEN);
            event.getToolTip().add(estimatedComponent);
        }
        if (((Boolean)CustomizedConfig.SHOW_ESTIMATED_BUFF_TOOLTIP.get()).booleanValue() && !foodProperty.m_38749_().isEmpty()) {
            foodProperty.m_38749_().forEach(buff -> {
                MutableComponent estimatedBuff = Component.m_237110_((String)"tooltip.customized.estimated_buff", (Object[])new Object[]{Component.m_237115_((String)"estimated.customized.buff"), Component.m_237115_((String)((MobEffectInstance)buff.getFirst()).m_19576_()), ((MobEffectInstance)buff.getFirst()).m_19557_()}).m_130940_(ChatFormatting.GREEN);
                event.getToolTip().add(estimatedBuff);
            });
        }
    }

    private static void addFoodCategory(ItemTooltipEvent event, ItemStack stack) {
        event.getToolTip().add(Component.m_237115_((String)("tooltip.customized" + (stack.m_204117_(ModTag.SEASONING) ? ".food_category_seasoning" : ".food_category_food"))).m_130940_(ChatFormatting.BLUE));
    }

    private static boolean canShow() {
        return (Boolean)CustomizedConfig.SHOW_NUTRIENT_VALUE_TOOLTIP.get() != false || (Boolean)CustomizedConfig.SHOW_NUTRIENT_VALUE_TOOLTIP.get() != false || (Boolean)CustomizedConfig.SHOW_ESTIMATED_BUFF_TOOLTIP.get() != false;
    }

    private static boolean isCtrlKeyPressed() {
        return InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)341) || InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)345);
    }
}

