/*
 * Decompiled with CFR 0.152.
 */
package mangopill.customized.client.util;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import mangopill.customized.common.block.AbstractPotBlock;
import mangopill.customized.common.block.entity.AbstractPlateBlockEntity;
import mangopill.customized.common.block.entity.AbstractPotBlockEntity;
import mangopill.customized.common.block.entity.BrewingBarrelBlockEntity;
import mangopill.customized.common.block.state.PotState;
import mangopill.customized.common.item.AbstractPlateItem;
import mangopill.customized.common.util.PropertyValueUtil;
import mangopill.customized.common.util.category.NutrientCategory;
import mangopill.customized.common.util.value.PropertyValue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.StainedGlassPaneBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.tuple.Pair;

public final class ClientUtil {
    private ClientUtil() {
    }

    public static int getMaxValueColor(Level level, List<ItemStack> stackList) {
        HashMap<NutrientCategory, Float> nutrientSums = new HashMap<NutrientCategory, Float>();
        for (ItemStack stack : stackList) {
            PropertyValue propertyValue = PropertyValueUtil.getPropertyValue(stack, level);
            if (propertyValue.isEmpty()) continue;
            for (Pair pair : propertyValue.toSet()) {
                NutrientCategory category = (NutrientCategory)((Object)pair.getKey());
                float value = ((Float)pair.getValue()).floatValue() * (float)stack.m_41613_();
                nutrientSums.put(category, Float.valueOf(nutrientSums.getOrDefault((Object)category, Float.valueOf(0.0f)).floatValue() + value));
            }
        }
        NutrientCategory maxCategory = null;
        double maxSum = 0.0;
        for (Map.Entry entry : nutrientSums.entrySet()) {
            if (!((double)((Float)entry.getValue()).floatValue() > maxSum)) continue;
            maxSum = ((Float)entry.getValue()).floatValue();
            maxCategory = (NutrientCategory)((Object)entry.getKey());
        }
        return maxCategory != null ? maxCategory.getColorWithAlpha() : -868256028;
    }

    public static void renderDrivePot(AbstractPotBlockEntity potBlockEntity, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay, float startLength, float startWidth, float startHeight, float endLength, float endWidth, float endHeight) {
        List<ItemStack> stackList = potBlockEntity.getItemStackListInPot(true, false);
        boolean dynamic = ((PotState)((Object)potBlockEntity.m_58900_().m_61143_(AbstractPotBlock.LID))).equals((Object)PotState.WITH_DRIVE);
        ClientUtil.renderDrive(Objects.requireNonNull(potBlockEntity.m_58904_()), stackList, poseStack, buffer, light, overlay, startLength, startWidth, startHeight, endLength, endWidth, endHeight, dynamic);
    }

    public static void renderDrivePlate(AbstractPlateBlockEntity plateBlockEntity, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay, float startLength, float startWidth, float startHeight, float endLength, float endWidth, float endHeight) {
        List<ItemStack> stackList = plateBlockEntity.getItemStackListInPlate(false);
        ClientUtil.renderDrive(Objects.requireNonNull(plateBlockEntity.m_58904_()), stackList, poseStack, buffer, light, overlay, startLength, startWidth, startHeight, endLength, endWidth, endHeight, true);
    }

    public static void renderDrivePlateItem(ItemStack stack, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay, float startLength, float startWidth, float startHeight, float endLength, float endWidth, float endHeight) {
        Item item = stack.m_41720_();
        if (item instanceof AbstractPlateItem) {
            AbstractPlateItem plateItem = (AbstractPlateItem)item;
            List<ItemStack> stackList = plateItem.getItemStackListInPlate(stack, false);
            if (Minecraft.m_91087_().f_91074_ != null) {
                ClientUtil.renderDrive(Minecraft.m_91087_().f_91074_.m_9236_(), stackList, poseStack, buffer, light, overlay, startLength, startWidth, startHeight, endLength, endWidth, endHeight, true);
            }
        }
    }

    public static void renderDrive(Level level, List<ItemStack> stackList, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay, float startLength, float startWidth, float startHeight, float endLength, float endWidth, float endHeight, boolean dynamic) {
        float globalTime = (float)(level.m_46467_() % 24000L) * 0.05f;
        for (ItemStack stack : stackList) {
            ItemStack newStack = stack.m_41777_();
            if (newStack.m_41619_()) continue;
            int count = newStack.m_41613_();
            int renderCount = count / 4 + (count % 4 > 0 ? 1 : 0);
            for (int i = 0; i < renderCount; ++i) {
                Random rand = new Random(stackList.lastIndexOf(stack) + i);
                int seed = Item.m_41393_((Item)newStack.m_41720_()) + rand.nextInt() + i;
                Random random = new Random(seed);
                float randX = startLength + random.nextFloat(endLength - startLength);
                float baseY = startHeight + random.nextFloat(endHeight - startHeight);
                float randZ = startWidth + random.nextFloat(endWidth - startWidth);
                float phase = (float)(seed % 1000) * 0.1f;
                float deltaY = (float)Math.sin(globalTime * 0.8f + phase) * 0.03f;
                float animatedY = dynamic ? baseY + deltaY : baseY;
                poseStack.m_85836_();
                poseStack.m_252880_(randX, animatedY, randZ);
                poseStack.m_252781_(Axis.f_252403_.m_252977_(random.nextFloat(360.0f)));
                poseStack.m_252781_(Axis.f_252529_.m_252977_(random.nextFloat(360.0f)));
                poseStack.m_252781_(Axis.f_252436_.m_252977_(random.nextFloat(360.0f)));
                poseStack.m_85841_(0.3f, 0.3f, 0.3f);
                ItemStack renderItemStack = newStack.m_41777_();
                renderItemStack.m_41764_(1);
                Minecraft.m_91087_().m_91291_().m_269128_(renderItemStack, ItemDisplayContext.FIXED, light, overlay, poseStack, buffer, null, seed);
                poseStack.m_85849_();
            }
        }
    }

    public static void renderBrewingBarrel(Level level, BrewingBarrelBlockEntity barrelBlockEntity, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay, float startX, float startY, float startZ) {
        List<ItemStack> stackList = barrelBlockEntity.getItemStackListInBrewingBarrel(false);
        BlockState state = Objects.requireNonNull(barrelBlockEntity.m_58904_()).m_8055_(barrelBlockEntity.m_58899_());
        if (level == null) {
            return;
        }
        if (state.m_61138_((Property)BlockStateProperties.f_61374_)) {
            for (int i = 0; i < stackList.size(); ++i) {
                poseStack.m_85836_();
                ItemStack itemStack = stackList.get(i);
                int col = i % 2;
                int row = i / 2;
                float x = startX + (float)col * startX;
                float y = startY + (float)row * startY;
                ClientUtil.adjust(poseStack, y, startZ, state, x, startZ);
                if (itemStack != null && !itemStack.m_41619_()) {
                    ItemStack renderItemStack = itemStack.m_41777_();
                    renderItemStack.m_41764_(1);
                    Minecraft.m_91087_().m_91291_().m_269128_(renderItemStack, ItemDisplayContext.FIXED, light, overlay, poseStack, buffer, null, 0);
                }
                poseStack.m_85849_();
            }
            ItemStack renderItemStack = barrelBlockEntity.getItemStackHandler().getStackInSlot(barrelBlockEntity.getInputSlot()).m_41777_();
            renderItemStack.m_41764_(1);
            float x = 3.0f * startX;
            poseStack.m_85836_();
            ClientUtil.adjust(poseStack, startY, startZ, state, x, startZ);
            if (!renderItemStack.m_41619_()) {
                renderItemStack.m_41764_(1);
                Minecraft.m_91087_().m_91291_().m_269128_(renderItemStack, ItemDisplayContext.FIXED, light, overlay, poseStack, buffer, null, 0);
            }
            poseStack.m_85849_();
        }
    }

    private static void adjust(PoseStack poseStack, float startY, float startZ, BlockState state, float x, float z) {
        switch ((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)) {
            case NORTH: {
                z += 1.0f - 2.0f * startZ;
                break;
            }
            case SOUTH: {
                x = 1.0f - x;
                break;
            }
            case WEST: {
                z = 1.0f - x;
                x = 1.0f - startZ;
                break;
            }
            case EAST: {
                z = x;
                x = startZ;
            }
        }
        poseStack.m_252880_(x, startY, z);
        poseStack.m_85841_(0.1f, 0.1f, 0.1f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(360.0f - ((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_()));
    }

    public static void renderModel(@Nonnull ItemStack stack, @Nonnull ItemDisplayContext displayContext, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource multiBufferSource, int light, int overlay) {
        BlockItem blockItem;
        Block block;
        Item item;
        BakedModel model = Minecraft.m_91087_().m_91291_().m_115103_().m_109393_().m_119422_(new ModelResourceLocation("customized", "soup_bowl_with_drive_renderer", "inventory"));
        boolean flag1 = displayContext != ItemDisplayContext.GUI && !displayContext.m_269069_() && (item = stack.m_41720_()) instanceof BlockItem ? !((block = (blockItem = (BlockItem)item).m_40614_()) instanceof HalfTransparentBlock) && !(block instanceof StainedGlassPaneBlock) : true;
        for (BakedModel passModel : model.getRenderPasses(stack, flag1)) {
            for (RenderType renderType : passModel.getRenderTypes(stack, flag1)) {
                VertexConsumer vertexConsumer = flag1 ? ItemRenderer.m_115222_((MultiBufferSource)multiBufferSource, (RenderType)renderType, (boolean)true, (boolean)stack.m_41790_()) : ItemRenderer.m_115211_((MultiBufferSource)multiBufferSource, (RenderType)renderType, (boolean)true, (boolean)stack.m_41790_());
                Minecraft.m_91087_().m_91291_().m_115189_(passModel, stack, light, overlay, poseStack, vertexConsumer);
            }
        }
    }
}

